#version 450

#include "/shaders/common.glsl"
#include "/shaders/math.glsl"
#include "/shaders/image_based_lighting.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal_worldspace;
layout (location = 2) out vec3 v_tangent_worldspace;
layout (location = 3) out vec3 v_pos_worldspace;
layout (location = 4) out vec3 v_camera_pos_worldspace;

layout (location = 5) out vec3 v_greet_uv;
layout (location = 6) out vec3 v_palette_color;


layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_world;
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    vec3 g_light_dir_worldspace_norm;
    float g_app_time;

    vec3 instance_move;
    float displacement;
    vec2 scale;
    float uv_zoom;

    vec4 A;
    vec4 B2;
    vec4 C;
    float time;
    vec4 D2;

    vec4 E;
    vec4 Ei;

    vec4 G;
    vec4 G2;

    vec4 IP;
};

#include "distort.glsl"

// iq's sine palette
vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d ) {
    return a + b*cos( 6.28318*(c*t+d) );
}

void main() {
    float i = gl_InstanceIndex;

    vec3 pos = a_position;
    pos.xz *= scale;
    vec3 normal = a_normal;
    vec3 tangent = a_tangent;

//    pos *= pos_scale;
    mat3 rot = mat3(rotate_x_matrix(PI/2.0));
    pos = rot * pos;
    pos.z += displacement;

    float t = time * (D2.z + D2.y * i) - i*D2.x - D2.w*100;
    pos.y += t;

    distort_side(pos, normal, tangent, E + Ei * i);

    pos.z += C.x * i * 0.1;
    pos.x += cos(i*B2.x+B2.w)* B2.z;

    distort(pos, normal, tangent, A);

    v_pos_worldspace = (g_world_from_model * vec4(pos, 1.0)).xyz;

    gl_Position = g_projection_from_world * vec4(v_pos_worldspace, 1.0);

    v_uv = a_uv * scale * uv_zoom;
    v_normal_worldspace = mat3(g_world_from_model) * normal;
    v_tangent_worldspace = mat3(g_world_from_model) * tangent;
    v_camera_pos_worldspace = calculate_camera_pos_worldspace(g_camera_from_world);

    float gu = 1-a_uv.y;
    float gv = a_uv.x * G.z * 0.1 + G.w * 0.1 + G.x * 0.01 * gl_InstanceIndex;
    v_greet_uv = vec3(gu, gv, 0);

    v_palette_color = pal(i*0.124332, vec3(0.8,0.5,0.4),vec3(0.2,0.4,0.2),vec3(2.0,1.0,1.0),vec3(0.0,0.25,0.25));
}