#version 450

#include "/shaders/math.glsl"
#include "/shaders/image_based_lighting.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal_worldspace;
layout (location = 2) out vec3 v_tangent_worldspace;
layout (location = 3) out vec3 v_pos_worldspace;
layout (location = 4) out vec3 v_camera_pos_worldspace;

layout (location = 5) out vec3 v_material_adjustment;

layout (set = 0, binding = 1) uniform sampler2D displacement_map;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_world;
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    vec3 g_light_dir_worldspace_norm;
    float g_app_time;

    float uv_scale;
    float pos_scale;
    float speed;
    float time;

    vec4 A;
    vec4 C;
    vec4 E;
};

#include "distort.glsl"


void main() {
    mat3 rot = mat3(rotate_x_matrix(PI/2.0));

    vec3 pos = a_position * pos_scale;
    pos = rot * pos;
    pos.z += C.y;

    rot = transpose(rot);

    vec3 normal = a_normal;
    vec3 tangent = a_tangent;
    normal = rot * normal;
    tangent = rot * tangent;

    distort(pos, normal, tangent, A);

    vec2 uv = a_uv * uv_scale * pos_scale;
    uv.y += time * speed;

    v_pos_worldspace = (g_world_from_model * vec4(pos, 1.0)).xyz;


    gl_Position = g_projection_from_world * vec4(v_pos_worldspace, 1.0);

    v_uv = uv;
    v_normal_worldspace = mat3(g_world_from_model) * normal;
    v_tangent_worldspace = mat3(g_world_from_model) * tangent;
    v_camera_pos_worldspace = calculate_camera_pos_worldspace(g_camera_from_world);
}