const float epsilon = 0.01f;

vec2 path2d(float x, vec4 A) {
    float s = sin(x * A.x);
    float y = s * A.z + x * A.w;
    return vec2(x, y);
}

void distort(inout vec3 p, inout vec3 normal, inout vec3 tangent, in vec4 A) {
    vec2 py = path2d(p.y, A);
    vec2 pn = path2d(p.y + epsilon, A);

    vec3 vx = vec3(1, 0, 0);
    vec3 vy = normalize(vec3(0, pn-py));
    vec3 vz = -cross(vy, vx);
    mat3 m = mat3(vx, vy, vz);

    p = vec3(0, py) + p.x * vx + p.z * vz;

    m = transpose(m);

    normal = m *normal;
    tangent = m * tangent;
}

float path2dm(float x, vec4 A) {
    float s = sin(x * A.x + A.y);
    return s * A.z + x * A.w;
}

void distort_side(inout vec3 p, inout vec3 normal, inout vec3 tangent, in vec4 A) {
    float x = path2dm(p.y, A);
    vec3 pd1 = vec3(x, p.y, 0);

    float yn = p.y + epsilon;
    float xn = path2dm(yn, A);
    vec3 pd2 = vec3(xn, yn, 0);

    vec3 vz = vec3(0, 0, 1);
    vec3 vy = normalize(pd2 - pd1);
    vec3 vx = cross(vz, vy);

    mat3 m = mat3(vx, vy, vz);

    p = vec3(x, p.y, p.z) + p.x * vx;

    m = transpose(m);

    normal = m *normal;
    tangent = m * tangent;
}
