#version 450

#include "/shaders/math.glsl"
#include "/shaders/image_based_lighting.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal_worldspace;
layout (location = 2) out vec3 v_tangent_worldspace;
layout (location = 3) out vec3 v_pos_worldspace;
layout (location = 4) out vec3 v_camera_pos_worldspace;

layout (location = 5) out vec3 v_material_adjustment;

//layout (set = 0, binding = 1) uniform sampler2D displacement_map;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_world;
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    vec3 g_light_dir_worldspace_norm;
    float g_app_time;

    vec3 instance_move;
    float displacement;
    float rank;
    float zoom;

    vec4 A;
    vec4 B;
    vec4 C;
    float time;
    vec4 D;
};

const float epsilon = 0.01f;

vec2 path2d(float x, float t) {
    float y = sin(x * A.x + t * A.y) * A.z + x * A.w;
    return vec2(x, y);
}

vec3 distort(vec3 p, float t) {
    vec2 py = path2d(p.y, t);
    vec2 pn = path2d(p.y + epsilon, t);

    vec3 vx = vec3(1, 0, 0);
    vec3 vy = normalize(vec3(0, pn-py));
    vec3 vz = -cross(vy, vx);

    vec3 res = vec3(0, py) + p.x * vx + p.z * vz;
    return res;
}

void main() {
    float i = gl_InstanceIndex;

    vec3 move = vec3(cos(i*C.x+C.w), 0, cos(i*C.y+C.w)) * C.z;

    vec3 pos = a_position;
    vec3 normal = normalize(a_normal);
    vec3 tangent = a_tangent;

    pos.z += B.w;
    float t = time * (1+D.y * i) + i*D.x;
    pos = distort(pos, t) + move;
    pos.y += cos(t * A.y + B.y) * B.x + B.z;

    v_pos_worldspace = (g_world_from_model * vec4(pos, 1.0)).xyz;

    gl_Position = g_projection_from_world * vec4(v_pos_worldspace, 1.0);

    v_uv = a_uv;
    v_normal_worldspace = mat3(g_world_from_model) * normal;
    v_tangent_worldspace = mat3(g_world_from_model) * tangent;
    v_camera_pos_worldspace = calculate_camera_pos_worldspace(g_camera_from_world);
}