#version 450

#include "/shaders/math.glsl"
#include "/shaders/image_based_lighting.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal_worldspace;
layout (location = 2) out vec3 v_tangent_worldspace;
layout (location = 3) out vec3 v_pos_worldspace;
layout (location = 4) out vec3 v_camera_pos_worldspace;
layout (location = 5) out vec3 v_light_dir_worldspace_norm;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_world;
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    vec3 g_light_dir_worldspace_norm;

    vec3 instance_move;
    float displacement;
    float zoom;
    float time;
    float g_simulation_frame_ratio;

    vec4 A;
    vec4 B;
    float quant;
    float cam_time;
};


#include "particles.glsl"
#include "camera-glitch.glsl"

layout (set = 0, binding = 1) buffer readonly ParticlesCurrent {
    Particle buf[];
} particles_current;

layout (set = 0, binding = 2) buffer readonly ParticlesNext {
    Particle buf[];
} particles_next;


vec3 get_particle_position() {
    vec3 current = particles_current.buf[gl_InstanceIndex].position;
    vec3 next = particles_next.buf[gl_InstanceIndex].position;
    return mix(current, next, g_simulation_frame_ratio);
}

void main() {
    float i = gl_InstanceIndex ;

    vec2 uv = a_uv;

    vec3 pos = a_position * zoom;

    mat4 rot = rotate_world(cam_time, quant, A, B);

    vec3 particle_pos = get_particle_position();
    pos += particle_pos;

//    float t = time + g_app_time * 0.05;
//    pos += vec3(cos(t+i), sin(t*1.14312+i*0.12312), cos(t*1.1237658+i*0.43534))*5;

    mat4 world_from_model = rot * g_world_from_model;

    v_pos_worldspace = (world_from_model * vec4(pos, 1.0)).xyz;

    gl_Position = g_projection_from_world * vec4(v_pos_worldspace, 1.0);

    v_uv = uv;
    v_normal_worldspace = mat3(world_from_model) * a_normal;
    v_tangent_worldspace = mat3(world_from_model) * a_tangent;
    v_camera_pos_worldspace = calculate_camera_pos_worldspace(g_camera_from_world);
    v_light_dir_worldspace_norm = mat3(rot) * g_light_dir_worldspace_norm;
}