

#pragma optionNV unroll all
#define MAX_LIGHTS 8
#define MAX_BONES 78

#define NUMLIGHTS 4


uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];

varying vec4 vpos; 

    varying vec3 v;
    varying vec3 N;
    varying vec3 T;
    varying vec3 B;
    varying vec3 originalv;

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec3 vertexOriginalPosition;
/*
in vec2 textureCoord;
in vec3 vertexTangent;
in float vertexTangentHandedness;
in vec4 vertexBones;
in vec4 vertexWeights;
*/
uniform mat4 depthBiasMVP[NUMLIGHTS];
varying vec4 ShadowCoord[NUMLIGHTS];

uniform vec4 Lights[NUMLIGHTS];
uniform vec4 LightsPos[NUMLIGHTS];

varying float ShadowAngle[NUMLIGHTS];
varying vec4 vN_;
varying vec4 vP_;



uniform int hasAnim[1];
uniform mat4 bonePos[MAX_BONES];
uniform mat4 boneRPos[MAX_BONES];
uniform mat4 boneRot[MAX_BONES];
uniform mat4 boneScl[MAX_BONES];

varying vec3 alightVec[MAX_LIGHTS];
varying vec3 aeyeVec[MAX_LIGHTS];
varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];





vec3 tmpVec;

void main(void)
{
vec4 vP;
vec4 vOP;
vec4 vN;
vec4 vT=vec4(0,0,0,0);
	
	vP=vec4(vertexPosition.xyz, 1.0);
	vN=vec4(vertexNormal.xyz, 1.0);
	vOP=vec4(vertexOriginalPosition.xyz, 1.0);
	//vT=vec4(vertexTangent.xyz, 1.0);

vN_=vN;
vP_=vP;

    
    gl_Position = gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0); 

    


 




vpos=gl_ModelViewMatrix * vec4(vP.xyz, 1.0);


for (int i=0;i<NUMLIGHTS;i++){
    ShadowCoord[i] = depthBiasMVP[i] * vec4(vP.xyz, 1.0);
}

    texCoord = vec2(0,0);

	
	vec3 n = normalize(gl_NormalMatrix * vec3(vN.x,vN.y,vN.z));
	vec3 t = normalize(gl_NormalMatrix * vec3(vT.x,vT.y,vT.z));
	
	
	
	


	//vec3 b = cross(n, t) * vertexTangentHandedness;
    vec3 b = vec3(0,0,0);
    
	
	

	
	vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(vP.xyz, 1.0));

    
    
    

    
for (int i=0;i<NUMLIGHTS;i++){
    

    
    ShadowAngle[i] = dot(normalize(vec3(Lights[i].xyz)),n);

    

    
    
    

}
    
    

for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	
    tmpVec = vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i]) - vVertex;

	alightVec[i].x = dot(tmpVec, t);
	alightVec[i].y = dot(tmpVec, b);
	alightVec[i].z = dot(tmpVec, n);

	tmpVec = -vVertex;

	}
   }

   
   
    v=vVertex;
    N=normalize(n);
    T=normalize(t);
    B=normalize(b);
    originalv=vertexOriginalPosition;
}
