



uniform sampler2D tInput;
uniform float testfactor;



const vec2 resolution=vec2(1920.0f,1080.0f);

float max_distort = 1.15/4.65;

vec2 barrelDistortion(vec2 coord, float amt) {
float zoom=1.35/1.25;

    vec2 coord2=coord;

	vec2 cc = coord2 - vec2(0.5);
	float dist = dot(cc, cc);

	
	vec2 res=coord2 + cc * dist * amt;
	
	
	
	
	res=(res-vec2(0.5))/zoom+vec2(0.5);
	
	
	
	
	return res;

	
}

float sat( float t )
{
	return clamp( t, 0.0, 1.0 );
}

float linterp( float t ) {
	return sat( 1.0 - abs( 2.0*t - 1.0 ) );
}

float remap( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

vec4 spectrum_offset( float t ) {
	vec4 ret;
	float lo = step(t,0.5);
	float hi = 1.0-lo;
	float w = linterp( remap( t, 1.0/6.0, 5.0/6.0 ) );
	
	ret = vec4(lo,1.0,hi, 1.) * vec4(1.0-w, w, 1.0-w, 1.);

	return pow( ret, vec4(1.0/2.2) );
}

const int num_iter = 6;
const float reci_num_iter_f = 1.0 / float(num_iter);

void main()
{







	
	vec2 uv=(gl_FragCoord.xy/resolution.xy);
	gl_FragColor = texture2D( tInput, uv);

	
	
}
