-- tunnelrun
-- jtruk
-- For CoLD SToRAGE gig
-- at Mountain Bytes 24

local S=math.sin
local C=math.cos
local RAND=math.random
mPi=math.pi
mPi2=mPi*2
mMax=math.max
mMin=math.min
FAR_DIST=200

SHAPES={}

TEXT=
	"REBOOT...\n"
	.. "...\n"
	.. "\n"
	.. "READY\n"
	.. "\n"
 .. "DECONSTRUCTING MUSIC\n"
 .. "SPECTRUM ANALYSIS\n"
 .. "RETICULATING SPLINES\n"
	.. "BYTING MOUNTAINS\n"
	.. "STORING COLDS\n"
	.. "JUICING BASS\n"
	.. "MORE COWBELL?\n"
	.. "HANDS IN THE MOUNTAIN AIR\n"
ITEXT=10000

function randomiseTable(t)
	local newT={}
	repeat
		local iPos=RAND(1,#t)
		table.insert(newT,t[iPos])
		table.remove(t,iPos)
	until(#t==0)
	return newT
end

function makeRGBfn()
	t=randomiseTable({"a","a+1","a+2"})

	local v1=RAND()<.5 and "c1" or "64+c1/2"
	local v2=RAND()<.5 and "c2" or "64+c2/2"
	local v3=RAND()<.5 and "c3" or "64+c3/2"
	fn="local a=16320+i*3"
	fn=fn.."poke("..t[1]..","..v1..")"
	fn=fn.."poke("..t[2]..","..v2..")"
	fn=fn.."poke("..t[3]..","..v3..")"

	setRGB=load("i,c1,c2,c3=...;" .. fn)
end

function switchRGBfn()
	makeRGBfn()

 -- border always black
	vbank(0)
	poke(16320,0)
	poke(16321,0)
	poke(16322,0)

	vbank(1)
	-- text shadow - always black
	poke(16326,0)
	poke(16327,0)
	poke(16328,0)
end

switchRGBfn()

function SCN(y)
	vbank(0)
	for c=1,15 do
	 local i=c/15
		setRGB(c,
			i*(155+S(T*.013+y*.0044)*100),
			i*(155+S(T*.02+i*.0024)*100),
			i*(155+S(T*.017+i*.0054)*100)
		)
	end

	if y>80 then
		vbank(1)
		local g=(160+(y%2)*15)-((120-y)*4)
		setRGB(1,0,g,0)
--		setRGB(2,0,0,0)
	end
end

function BOOT()	
	ITEXT=RAND(0,1000)
	for i=0,100 do
		textUpdate()
	end
end

T=0
LAST_T=0
function TIC()
	LAST_T=T
	T=time()/12

	if T%400<LAST_T%400 then
		switchRGBfn()
	end
	
	poke(0x3FFB,0)
	vbank(0)
	cls(0)

	if T%40<LAST_T%40 then
		createShape()
	end

	table.sort(SHAPES,function(a,b)
			return a.spawnT<b.spawnT
		end
	)
	
	for r=0,5 do
		rect(
			RAND(-80,240),
			RAND(-80,136),
			RAND(10,80),
			RAND(10,80),
			3
		)
	end
	
	for i=1,#SHAPES do		
		if(SHAPES[i].isAlive)then
			drawShape(SHAPES[i])
		end
	end

	for y=0,136,2 do
		x1=-10
		repeat
			w=RAND(6,10)
			x2=x1+w
			c=RAND(1,6)
			for x=x1,x2 do
				p=pix(x,y)
				pix(x,y,mMin(15,c+p))
			end

			x1=x2		
		until(x2>=240)
	end
	
	print("jtruk",208,128,0)
	print("jtruk",207,127,5)

	vbank(1)
	cls()
	if T%10<LAST_T%10 then
		textUpdate()
	end
	textDraw()	
end

LINES={""}

function textUpdate()
	local iCh=ITEXT+1
 local ch=TEXT:sub(iCh,iCh)
	if ch=="\n" then
	 textNL()
	else
		textChar(ch)
	end
 ITEXT=(ITEXT+1)%#TEXT
end

function textNL()
	if #LINES>=4 then
	 table.remove(LINES,1)
	end
 table.insert(LINES,"")
end

function textChar(ch)
 LINES[#LINES]=LINES[#LINES] .. ch
end

function textDraw()
	for i,l in ipairs(LINES) do
	 if i==#LINES then
			if T%40<20 then
				l=l .. "_"
			end
		end
		
		local y=125-(#LINES-i)*8
		print(l,9,y+1,2)
		print(l,8,y,1)
	end
end

function drawShape(shape)
	z=(((shape.spawnT+FAR_DIST-T)*.0015)*100)%FAR_DIST

	sizeOuter=100
	keepAlive=drawPoly(shape.x,shape.y,
		z,sizeOuter,shape.nSides,false
	)

	sizeInner=sizeOuter*shape.hole
	drawPoly(shape.x,shape.y,
		z,sizeInner,shape.nSides,true
	)
	
	if(not keepAlive)then
		shape.isAlive=false
	end
end

function drawPoly(xC,yC,z,size,nSides,isBlack)
	for i=0,nSides-1 do
		a1=i*mPi2/nSides
		a2=(i+1)*mPi2/nSides
		p1x=S(a1)*size+xC
		p1y=-C(a1)*size+yC
		p2x=S(a2)*size+xC
		p2y=-C(a2)*size+yC
		p0=proj(xC,yC,z)
		p1=proj(p1x,p1y,z)
		p2=proj(p2x,p2y,z)
		if(p0.z>-20)then
			c=isBlack and 0 or mMax(1,(15*(30-z)/30)^.7)
			tri(p0.x,p0.y,p1.x,p1.y,p2.x,p2.y,c)
		else
			return false
		end
	end
	
	return true
end

function proj(x,y,z)
	return {
		x=120+x/z,
		y=68+y/z,
		z=z/z,
	}
end

function	createShape()
	SHAPES[getFreeShape()]={
		isAlive=true,
		spawnT=T,
		x=60*(RAND()-.5),
		y=60*(RAND()-.5),
		nSides=(RAND()<.5)
			and 100
			or RAND(3,7),
		c=RAND(1,11),
		hole=0.85
	}
end

function getFreeShape()
	for i=1,#SHAPES do
		if not SHAPES[i].isAlive then
			return i
		end
	end
	
	return #SHAPES+1
end