-- credits
-- jtruk
-- For CoLD SToRAGE gig
-- at Mountain Bytes 24

local T=0
local M=math
local S,C,PI,ABS=M.sin,M.cos,M.pi,M.abs
local TAU,ATAN,RAND=PI*2,M.atan2,M.random
local MIN,MAX=M.min,M.max

function CLAMP(v,min,max)
	return MIN(MAX(v,min),max)
end

local CAM_Z=1.3

local PLAQUE_TEXW=240
local PLAQUE_TEXH=45

-- INFORMICS 7x6
FONTDATA="28E08beA15DADADA2DA6LBLBJA10KAPBKAPBKA6EAOBOAPAEA6NAMAGADALA6MAGBODLBOCA5DADABA10GADADADAGA6DAGAGAGADA6OAPBPBPBOA8CAHACA12DADABA10HA16DADA6MAMAGADADA6OALBNBLBOA6GAHAGAGAPA6HAMAGADAOA6HAMAOAMAHA6BANAOBMAMA6PABAHAMAHA6OBDAPALBOA6PBIBMAGAGA6OALBOALBOA6OALBOBIBPA6DADA2DADA6DA2DADABA6EAOBPBOBEA8HA2HA8EAPAPBPAEA6PAIBOA2GA6OABBNABAOA6OALBPBLBLBA5PALBPALBPA6OBDADADAOBA5PALBLBLBPA6OBDAHADAOBA5OBDAHADADA6OBDALBDBOBA5LBLBPBLBLBA5DADADADADA6PAMAMAMAHA6LBLAPALBLBA5DADADADAOBA5OBLCLCDCDCA5PALBLBLBLBA5OALBLBLBOA6PALBPADADA6GALALALAOBA5PALBPALBLBA5OBDAOAIBPA6PAGAGAGAGA6LBLBLBLBOA6LBLBLBKAEA6BDBDFDFDOBA5LBLBOALBLBA5LBLBOAGAGA6PBIBOADAPBA5DABABABADA6DADAGAMAMA6DACACACADA6EAKABBA17HA6DADACA12OBLBLBOBA5DAPALBLBPA8OBDADAOBA5IBOBLBLBOBA7OALBHAOA6OADAHADADA8OALBOBIBPA4DAPALBLBLBA5DA2DADADA6IBAAIBIBLBOA4DALBPALBLBA5DADADADAOA8OBLCLCDCA7PALBLBLBA7OALBLBOA8PALBLBPADA6OBLBLBOBIBA5OADADADA8OBHAMBPA6GAPAGAGAMA8LBLBLBOA8LBLBOAEA8BDFDFDOBA7LBOALBLBA7LBLBOAGA8PBMAGAPBA5MACABACAMA6BABABABABA6DAEAIAEADA22"

function setRealRGB(c,r,g,b)
	local a=16320+c*3
	poke(a,r)
	poke(a+1,g)
	poke(a+2,b)
end

CREDITS={
	{n="Suule",r="EFFECTS"},
	{n="Vurpo",r="EFFECTS"},
	{n="Superogue",r="EFFECTS"},
	{n="Blossom",r="EFFECTS"},
	{n="HeNeArXn",r="EFFECTS"},
	{n="Mantratronic",r="EFFECTS"},
	{n="Ultrazool",r="EFFECTS"},
	{n="Aldroid",r="EFFECTS"},
	{n="Catnip",r="EFFECTS"},
	{n="jtruk",r="BYTEJAMMER & EFFECTS"},
	{n="RaccoonViolet",r="VISUAL ORGANISER"},
	{n="Decca",r="FONTS"},
}

PLAQUES={}

function setPlaque(i,credit,roleTS,nameTS)
	PLAQUES[i]={
	 t=0,
		credit=credit,
		wName=print(credit.n,0,140,0,false,nameTS),
		wRole=print(credit.r,0,140,12,false,roleTS),
		x=0,y=0,z=0,
		rX=0,rY=0,rZ=0,
	}
end

function drawPlaques()
 vbank(0)
 cls()
 local setNext=nil
 for i,p in ipairs(PLAQUES) do
		if p.t>300 then
			setNext=i
		elseif p.t>250 then
		 p.x=-((p.t-250)/50)*15
		elseif p.t<50 then
		 p.x=15-(p.t/50)*15
		end
  p.y=((i-1)-.5)*3+S(T*.1)*.1
  p.z=2+S(i*1.6+T*.02)*3
		p.rX=S(i*2+T*.018)*.4
		p.rY=S(i+T*.02)*.5
		p.rZ=S(i*3+T*.03)*.2
  drawPlaqueTex(i,p)
  p.t=p.t+1
 end
 vbank(1)
 cls()
 for i,p in ipairs(PLAQUES) do
  drawPlaqueGeom(i,p)
 end
 
 if setNext~=nil then
  incCredit()
		setPlaque(setNext,getCredit(),2,3)
 end
end

function drawPlaqueTex(i,p)
 local plY=(i-1)*PLAQUE_TEXH
	local tw,th=240,PLAQUE_TEXH
 local credit=p.credit

	local boxw,boxh=MAX(p.wName+20,p.wRole+8),th
	rect((tw-boxw)/2,plY,boxw,boxh,3)
	rectb((tw-boxw)/2,plY,boxw,boxh,1)

	local px,py=(tw-p.wRole)/2,plY+6
	print(credit.r,px+1,py+1,14,false,2)
	print(credit.r,px-1,py-1,10,false,2)
	print(credit.r,px,py,12,false,2)

	local px,py=(tw-p.wName)/2,plY+23
	print(credit.n,px+1,py+1,10,false,3)
	print(credit.n,px-1,py-1,14,false,3)
	print(credit.n,px,py,12,false,3)

	local twh=tw/2
	local thh=th/2
	for y=0,th-1 do
	 local pixY=plY+y
		for x=0,tw-1 do
			local c=pix(x,pixY)
		 if c>=1 and c<=9 then
				local d=((twh-x-30)^2+((thh-y+5)*3)^2)^.5
				c=c+5+S(-p.rY+p.rZ*.3-d*.04+T*.06)*4
				pix(x,pixY,CLAMP(c,1,9))
		 elseif c>=10 and c<=15 then
				local d=((twh-x+30)^2+((thh-y-5)*3)^2)^.5
				c=c-S(-p.rY+p.rZ*.3-d*.04+T*.06)*2
				pix(x,pixY,CLAMP(c,10,15))
			end
		end
	end
end

function drawPlaqueGeom(i,p)
	local wh,hh=PLAQUE_TEXW/PLAQUE_TEXH,1
	local p1,p2,p3,p4=makePQuad(wh,hh)
	p1,p2,p3,p4=rotX(p1,p.rX),rotX(p2,p.rX),rotX(p3,p.rX),rotX(p4,p.rX)
	p1,p2,p3,p4=rotY(p1,p.rY),rotY(p2,p.rY),rotY(p3,p.rY),rotY(p4,p.rY)
	p1,p2,p3,p4=rotZ(p1,p.rZ),rotZ(p2,p.rZ),rotZ(p3,p.rZ),rotZ(p4,p.rZ)
	p1=add(p1,p.x,p.y,p.z)
	p2=add(p2,p.x,p.y,p.z)
	p3=add(p3,p.x,p.y,p.z)
	p4=add(p4,p.x,p.y,p.z)
	p1,p2,p3,p4=proj(p1),proj(p2),proj(p3),proj(p4)
	local texY0=(i-1)*PLAQUE_TEXH
	local texY1=i*PLAQUE_TEXH
	drawTTri(p1,p2,p3,0,texY0,PLAQUE_TEXW,texY1,false)
	drawTTri(p3,p4,p1,0,texY0,PLAQUE_TEXW,texY1,true)
end

function randomiseTable(t)
	local newT={}
	repeat
		local iPos=RAND(1,#t)
		table.insert(newT,t[iPos])
		table.remove(t,iPos)
	until(#t==0)
	return newT
end

function BOOT()
	fontLoad(FONTDATA)
 CREDITS=randomiseTable(CREDITS)
	vbank(0)
 setRealRGB(0,0,0,0)

	vbank(1)
 -- silver - text
 for i=10,15 do
  local v=255-200*(i-10)/(15-10)
	 setRealRGB(i,v,v,v)
	end
end

function SCN(y)
	vbank(0)
	-- stars
	local rMax=192+S(y*.01+T*.012)*64
	local gMax=192+S(y*.013+T*.01)*64
	local bMax=192+S(y*.017+T*.008)*64
 for i=1,15 do
  local v=i/15
  local t1=rMax*v
  local t2=gMax*v
  local t3=bMax*v
	 setRealRGB(i,t1,t2,t3)
	end

	vbank(1)
	-- gold - plaque
 setRealRGB(1,0,0,0)
 for i=1,9 do
  local v=(i-1)/(9-1)
  local t1=120+S(v*4+y*.08)*120/3
  local t2=120+S(v*2+y*.1)*120/3
  local t3=120+S(v*3+y*.12)*120/2
	 setRealRGB(i,t1,t2,t3)
	end
end

ICREDIT=0
function incCredit()
	ICREDIT=ICREDIT+1
end

function getCredit()
	return CREDITS[1+(ICREDIT%#CREDITS)]
end

TRIP_PLAQUE1=true
TRIP_PLAQUE2=true

function TIC() 	
	T=time()/12

	if TRIP_PLAQUE1 and T>50 then
		setPlaque(1,getCredit(),2,3)
		TRIP_PLAQUE1=false
	end
	if TRIP_PLAQUE2 and T>250 then
		incCredit()
		setPlaque(2,getCredit(),2,3)
		TRIP_PLAQUE2=false
	end

	poke(0x3FFB,0)

	drawPlaques()
		
	-- background
 vbank(0)
 cls()
 for i=0,100 do
	 local ySh=-ABS(S(i*.1+T*.035)*30)
  local s=((i^8.5+i^3.4+i)%1111)/1111
		local x=((i-(T+1000)*(1+s))%250)-5
		local y=((s*976+ySh*s)%145)-5
		circ(x,y,1,1+s*14)
 end
	print("jtruk",200,125,2)
end

function	makePQuad(wh,hh)
	return
		{x=-wh,y=-hh,z=0},
		{x=wh,y=-hh,z=0},
		{x=wh,y=hh,z=0},
		{x=-wh,y=hh,z=0}
end

function proj(p)
	local zF=CAM_Z-p.z*.1
	local sc=20
 return {
  x=120+sc*p.x/zF,
  y=68+sc*p.y/zF,
  z=zF,
 }
end

function add(p,x,y,z)
	return {
	 x=p.x+x,
		y=p.y+y,
		z=p.z+z,
	}
end

function rotX(p,a)
	return {
	 x=p.x,
		y=p.y*C(a)-p.z*S(a),
		z=p.y*S(a)+p.z*C(a),
	}
end

function rotY(p,a)
	return {
		x=p.x*C(a)-p.z*S(a),
	 y=p.y,
		z=p.x*S(a)+p.z*C(a),
	}
end

function rotZ(p,a)
	return {
		x=p.x*C(a)-p.y*S(a),
		y=p.x*S(a)+p.y*C(a),
	 z=p.z,
	}
end

function drawTTri(p1,p2,p3,pxL,pyL,pxH,pyH,flip)
	if flip==false then 
		t1x,t1y,t2x,t2y,t3x,t3y=pxL,pyL,pxH,pyL,pxH,pyH
	else
		t1x,t1y,t2x,t2y,t3x,t3y=pxH,pyH,pxL,pyH,pxL,pyL
	end

	ttri(
		p1.x,p1.y,
		p2.x,p2.y,
		p3.x,p3.y,
		t1x,t1y,t2x,t2y,t3x,t3y,
		2,
		0,
		p1.z,p2.z,p3.z
	)
end

-- FONT:

function fontLoad(str)
  local o=tonumber(str:sub(1,5),16) -- get (o)ffset
  local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
  local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
  local d = "" -- (d)ecoded data
  for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
    d = d .. m .. (m:sub(-1):rep(c))  
  end
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end