;*       = $0801
;        .word (+), 0  ;pointer, line number
;        .null $9e, format("%4d", main);SYS
;+       .word 0          ;basic line end

	CHROUT = $FFD2
	PNT = $d1		; Pointer to start of current screen line
	PLOT = $E50C		; Kernal routine moves cursor to (y,x)
	SAVE_XY = $B7B9		; Store XY to $71,$72 & $7a,$7b			 $FE2D
	SAVE_PT = $B7B5		; Copy $7a,$7b to $71,$72
	RESTORE_PT = $B7E2	; Copy $71,$72 to $7a,$7b
	SET_PT_TO_XY = $B7E6 	; Save X,Y to $7a, $7b
	ADD_A_TO_PT = $A8FC 	; Add A to $7a, $7b
	ADD_A_TO_GRAD = $B699 	; Add A to $35, $36, return $35 in A
	ADD_A_TO_ACC = $B6CB 	; Add A to $33, $34, store X,Y to $22, $23, restore A

	xdot = $4		; current pen bit
	home_xdot = $16		; origin pen bit

	width = $9		; width of current curve
	bend = $a		; bend of current curve
	acc = $33		; fractional Y position (.8)
	grad = $35		; current pen gradient
	pt = $7a		; pointer to current pen byte

*=$900	; SYS 2304
main

-	sta ($15),y		; clear the bitmap (and then some)
	iny
	bne -
	inc $16
	bpl -			; stop at $8000, and also pen origin to left-most bit

	ldy #$20
	sty $c7			; set reverse mode so we get bright green later
	jsr SAVE_XY		; store the address of the top-left corner for later

	jsr draw_curves		; first, draw all the curves that are down and right
	rol home_xdot		; set pen origin to right-most bit (carry is set)
				; The final curve left the pen pointer in the top right
	jsr SAVE_PT		; save this pen location as the new origin

	lda #<move_x_left
	sta mod_mov_1		; instead of moving pen left to right
	sta mod_mov_2		; move right to left instead
	jsr draw_curves		; and draw all the curves again

				; The final line moves the pen pointer back to the top left
-	pha			; put aside A
	jsr move_y		; move down a row
	pla			; restore A
	eor (pt),y		; Do XOR fill top to bottom
	sta (pt),y
	inx			; count 256 rows, more than enough
	bne -
	jsr one_char_right	; move one char over
	lda $7b                 ; 256 pixel rows = 256 * 40 bytes
	eor #$68                ; effectively subtract 40 from MSB
	sta $7b
	txa			; zero out A for next column
	inc $8f			; count 40 columns
	bpl -			; repeat

	lda #112		; prints as $50 = green
-	jsr CHROUT		; or RVS mode $d0 = light green
	bne -			; repeat forever

draw_curves
	ldx #data_end-data-1	; -1 because data is overlapped with code
-	lda data,x
	sta $d000-33,x		; latter curve data is also VIC settings
	pha			; push all the curve descriptions to the stack
	dex
	bpl -

next_curve
	pla			; starting gradient
	sta grad

	pla			; bending rate
	sta bend

	pla			; width*2 (+1)
	lsr
	sta width
	bcs skip_position	; if LSB was set, pen doesn't move 

	jsr RESTORE_PT		; Set the pen origin byte address
	lda home_xdot		; get pen origin bit
	sta xdot		; and go there

	pla			; curve starting X coordinate
	tay
mod_mov_1=*+1
-	jsr move_x		; move 1 pixel horizontally
	dey			; repeat X times
	bne -

	pla			; curve starting Y coordinate
	tax
	beq skip_position
-	jsr move_y		; move 1 pixel down
	dex			; repeat Y times
	bne -

skip_position
-	lda xdot		; get pen bit
	eor (pt),y		; XOR it 
	sta (pt),y		; into the bitmap
mod_mov_2=*+1
	jsr move_x		; move 1 pixel horizontally
+	lda bend
	jsr ADD_A_TO_GRAD 	; bend is gradient delta
	jsr ADD_A_TO_ACC	; gradient is fractional Y position delta
	bcc +			; did it wrap?
	jsr move_y
+	dec width		; repeat for width pixels
	bne -
	cpx grad		; last curve has gradient = 0
	bne next_curve
	rts
move_x
	lsr xdot		; Move pen bit right
	bne done_move
	ror xdot		; pen bit wraps round to MSB
one_char_right
	lda #8			; + $8
	bne move_add
move_x_left
	asl xdot		; Move pen bit left
	bne done_move
	rol xdot		; pen bit wraps round to LSB
	dec $7b			; - $100
	lda #$f8		; + $f8 = -8
move_add
	jsr ADD_A_TO_PT
done_move
	rts
move_y
	iny			; pen row +1
	cpy #8			; did we overflow to next char row?
	bcc done_move
	ldy #0
	inc pt+1		; + $100
	lda #$40		; + $40	 = +320
	bne move_add

data = *-1	;	grad, bend, width*2 (+1 or) [,X ,Y]
	;.byte	255, 
	.byte	$100-18,14*2, 123, 61+40-7+32	; eye bottom outside
	.byte	1, 15,13*2, 184, 54+40-7+32	; eye top outside
	.byte	1, 21,13*2, 136, 54+40-7+32	; eye top inside

	.byte	1, 5, 49*2, 160, 7+40-7+32
	.byte	31, 0, 95*2+1

	.byte	36, 10, 20*2, 90, 46+40-7+32
	.byte	1, 12, 20*2, 90, 45+40-7+32

	.byte	160,$100-2,26*2,16,45+40-7+32	; bottom edge of ears and chin
	.byte	255,$100-9,28*2+1
	.byte	1,2,43*2+1
	.byte	255,$100-11,24*2+1
	.byte	67, $100-3, 23*2+1

	.byte	50, 1, 10*2, 160-5, 71+40-7+32		; nostrils
	.byte	200, $100-18,12*2, 171, 63+40-7+32	; eye bottom inside (y pos should be 0 mod 16)
	.byte	255, 1, 32*2, 160-16, 84+40-7+32	; mouth

	.byte	0, 0, 63*2, 0, 0
;	.byte	0, 0, 0
data_end


