;; Winter Swim Trip / hannu
;; C64, 256 bytes
;; Lovebyte 2024
;
; SYS 4096 to start.
;
; A big shout out to Pestis whose seminar on procedural music inspired this.
; The music came first, then I had to learn to do textmode graphics on C64. I
; had some custom font code but then synchronizing simple patterns to the beat
; felt cooler than focusing on visuals. This is about the music.
;
; It's also my first larger prod for C64, hope you like it!
;
; Greets to all sizecoders!

;;;;
; The code contains some random stuff I tried and left out. Not trying to show
; polished source code. I believe just some hacked together code with a couple
; of comments here and there could be useful for another newcomer like me.
; Disassembly is already difficult to understand at this size category.

 .word $1000
 * = $1000
 line_nr = $fb
 t = $fc

; sta $d020
; sta $d021
;; setup: character ram
;; 32= $800 screen RAM, 12= $3000 character RAM
;lda #44
;sta $d018

mainloop:
 jsr chars
 jsr sleep
 clc ;; dunno why this is needed
 jsr playsid
 jmp mainloop

font:
 ;lda #$ff
 ;ldx #0
fontloop:
 ;sta $3000,x
 ;asl
 ;inx
 ;bne fontloop
 ;inc font+1
chars:
 lda t
 rol
 rol
 rol
 and #6
 ora #1
 sta colloop+1

 lda #25
 sta line_nr
lineloop:
 lda t
 ldx #40
 clc
 sbc line_nr
colloop:
 sbc #1
 ora #$c0
 dex
line_addr:
 sta $0400,x
 sta $d800,x
 bne colloop
; move pointer to next line
 dec line_nr
 beq chars_end
 clc
 lda line_addr+1
 adc #40
 sta line_addr+1
 sta line_addr+4
 bcc lineloop
 clc
 inc line_addr+2
 inc line_addr+5
 jmp lineloop
chars_end:
 lda #0
 sta line_addr+1
 sta line_addr+4
 lda #$04
 sta line_addr+2
 lda #$d8
 sta line_addr+5
 rts

sleep:
 ldx #$3f
sleeploop:
 dey
 bne sleeploop
 dex
 bne sleeploop
 rts

playsid:
 ; filter, volume
 lda #$1c
 sta $d418
 sta $d40a

 lda t+1
 and #1
 adc #$f5
 sta $d417

 inc t
 bne nz
 inc t+1

nz:
 ; channel 1 (arpeggio) & 3 (drum+bass)
 lda t
 and #$0f
 tax

; drum
 and #5
 beq drumtrack
nodrum:
 lda #0
 sta $d412  ; ch3 control
 beq skipdrum

drumtrack:
 txa
 sbc #5
 sta $d020  ; switch background color
 sta $d021
 and #8
 bne snare
 lda #$41
 sta $d412  ; ch3 control
 lda #4
 sta $d40f
 bne skipdrum

snare:
 lda #$81
 sta $d412  ; ch3 control
 sta $d40f  ; ch3 freq_hi
 ;bne skipdrum
skipdrum:
 
 lda notedata,x
 sta $d401  ; ch1 freq_hi

 ; channel 2 quarter-speed
 lda t
 lsr
 lsr
 ;filter
 sta $d416
 and #$0f
 tax

 lda notedata,x
 lsr
 sta $d408
 
 ; sustain, release
 lda #$80
 sta $d406
 sta $d40d
 lda #$f7
 sta $d414
 ; attack, decay
 lda #$04
 sta $d413
 sta $d411

 ; control ch1&2
 lda #$21
 sta $d404
 lda #$41
 sta $d40b

 rts

notedata:
.byt 16,24,20,30,40,32,30,24,8,12,18,30,36,30,48,40
