.include "swis.asm"


.equ sines,0x020000
.equ tex1,0x030000


.org 0x8000

Start:

screen_addr:
main:
	; Set Screen Mode 13 (320*256*8bpp)
	swi 0x116
	swi 0x10d

	; Disable cursor
	swi 0x36

	; Init sines
	mov r1,#2048
	mov r2,#32	; CX	; Starting Y (changed a bit from the X86 for the curve drawn to be more consistent)
	mov r3,#768	; SI	; Controls amplitude (I set it to be almost in the 0-255 range)
	mov r0,#sines
singen:
	mov r4,r2,LSR #8		; R4 = (CX >> 8)
	strb r4,[r0],#1			; Write 
	mov r4,#40				; Controls frequency (40 just happens to loop about 256 pixels)
	mul r4,r2,r4			; R4 = 40 * CX
	add r2,r2,r3			; CX = CX + SI	; moved here compared to where is at x86 code, to make sine more even
	sub r3,r3,r4,ASR #16	; SI = SI - (R4 >> 16) (DX in the x86 IMUL)
	subs r1,r1,#1
	bne singen

	mov r0,#sines
	mov r1,#tex1

	mov r4,#512
	texGenY:
		mov r3,#256
		texGenX:
			mov r2,r4
			mov r10,#4
			recurse:
				mov r8,r4,LSL r10
				ldrb r6,[r0,r8]
				mov r7,r3,LSL r10
				ldrb r5,[r0,r7]
				add r5,r5,r6
				and r5,r5,#127
				add r2,r2,r5,LSR r10
			subs r10,r10,#1
			bne recurse
			and r2,r2,#127
			mov r2,r2,LSR #5
			strb r2,[r1],#1
			subs r3,r3,#1
		bne texGenX
	subs r4,r4,#1
	bne texGenY


	; Read VDU values (Start Address mainly)
	adr r0, screen_addr_input
	adr r1, screen_addr
	swi OS_ReadVduVariables
	ldr r1,[r1]

	mov r12,#0
main_loop:
	mov r1,#screen_addr
	ldr r1,[r1]
	add r1,r1,#32

	mov r8,#tex1
	add r8,r8,r12,LSR #3

	mov r3,#256
	rendLoopY:
		mov r2,#256
		rendLoopX:
			ldrb r4,[r8],#1
			ldrb r5,[r8,r12,LSR #2]
			add r4,r4,r5
			strb r4,[r1],#1
			subs r2,r2,#1
		bne rendLoopX
		add r1,r1,#64
	subs r3,r3,#1
	bne rendLoopY

	add r12,r12,#4

	;mov r0,#OSByte_Vsync
	;swi OS_Byte

	swi OS_ReadEscapeState
	bcc main_loop

	swi OS_Exit

screen_addr_input:
	.long VD_ScreenStart, -1
