;;
;; play with 70_000 cycles in dosbox
;;

RADIUS equ 73

org     100h

  
  mov  al, 13h              ; set screen mode
  int  10h
  les  bp, [bx]             ; pointer to vga memory in ES and
  mov  ds, bp               ; other memory region for texture in DS

paintStart:

; TEXTURE
nextPixel:
  ; avg previous value and current 16bit-pixel
  add ax, [ds:di]
  rcr ax, 1

  ; avg with 16bit-pixel below
  add ax, [ds:di-256]
  rcr ax, 1

  dec ax

  mov [ds:di], ax ; paint 16bit-Pixel in texture
  cmpsw           ; increment di by 2

  loop nextPixel  ; do 2^16 pixels in texture, because cx starts at 0


  inc bp            ; increment time
  push BP           ; save, so register can be re-purposed after reading the time

  mov ax, bp
  cmp al, 119       ; collision at 128 - sound needs to start playing a bit earlier
  jne noPling
  ; pling sound
  mov 	dx, 0x330		; MIDI Port
	mov 	al, 0x98
	out 	dx, al			; send: note on (channel 0)
  mov   al, 115     ; high piano note
	out 	dx, al			; send: key	
	out 	dx, al			; send: velocity

noPling:

  ; calculate jump position
  mov AX, BP        ; bp still contains time
  imul AL
  mov DX, BP
  mov DH, AH
  add DH, RADIUS
  mov BP, DX        ; now use bp as x- and y- offset for center of the ball

; GLASSBALL
frameloop:
  mov ax,0xCCCD
  mul di			; dl = x , dh=y

  ; show glass ball, yet?
  mov bx, sp
  cmp word ss:[bx], 0x2200 + 128 + 256 + 256
  jb paintNoBall

  sub dx, bp ; move center of glass bowl with time to the right
  
  ; calculate z^2 = RADIUS^2 - (x^2 + y^2)
  mov bx, RADIUS*RADIUS ; RADIUS^2
  mov al, dl
  imul al     ; dx = x^2
  sub bx, ax
  mov al, dh
  imul al     ; dx = y^2
  sub bx, ax  ; result in bx
  jle paint

  ; calculate offset
  mov al, bh
  imul dh
  shr ax, 4   ; you can adjust the y-zoom factor of the glass ball here
  mov dh, al

  mov al, bh
  imul dl
  shr ax, 4   ; you can adjust the x-zoom factor of the glass ball here
  mov dl, al

paint:
  add dx, bp

paintNoBall:
  mov si, dx
  or si, 1    ; enforces to only use higher 8bits of 16bit pixels in texture
  lodsb       ; loads the higher 8bits from 16bit-pixel from texture

  add al, 16 + 8 + 4 + 1  ; colors start with 3 light gray followed by bright colors
  ; alternative versions of color ranges
  ;shl ax, 1  
  ;add al, 16
  ;add al, 43
  ;add al, 53
  
  stosb       ; write pixel on screen
  cmpsw

  loop frameloop ; do 2^16 pixels on screen, because cx starts at 0

  pop BP          ; restore time
  jmp paintStart
