var demoNumber = 1;

const demoTitles = ['', 'Shake! / APC, 1994', 'Drunk Tank / Quasimodos, 1995', 'Rotten Juice / MEC, 1996', 'Juzek / Koala, 1997', 'Zero / New Generation, 1998', 'Impossible But Real / Aids, 1999', 'Porażka / Taquart, 2000', 'Ergo Bibamus / Quasimodos, 2001', 'Too Hard 3 / Animkomials, 2002', 'Drab / Taquart, 2003', 'Back2life 2 / Taquart, 2004', 'Polymatrix / LaResistance, 2005', 'Bash! / Blowjobb, 2006', 'The Shrine / LaResistance, 2007', 'Unplugged / MEC, 2008', 'Ilusia / Mad Team, 2009', '48h / LaResistance, 2010', 'Too Silly / Lamers, 2011', 'High Tide / LaResistance, 2012', 'Triple Threat / Agenda + Mystic Bytes + Noice, 2013', 'Near / Agenda, 2014', 'Fifty Shades of Grey / Taquart, 2015', 'Unmec / Agenda, 2016', 'WePlash / Grey + MotionRide + Nir Dary, 2017', 'Seaxteen / Agenda, 2018', 'Unsolved / MEC, 2019', 'Cyberpunk 6502 / Agenda, 2020', 'Behold / Suspect, 2021', 'Bring back the eighties / Blowjobb, 2022', 'I, Robot / New Generation + Zelax, 2023'];

document.addEventListener("DOMContentLoaded", function() {  

    // Function to set the image source based on the demo number
    function setImageSource(demoNumber) {
        
        let nextDemoNumber = parseInt(demoNumber, 10);
        nextDemoNumber = nextDemoNumber.toString().padStart(2, '0');
        
        const imgSrc = `img/image_${nextDemoNumber}.png`;

        // Get the canvas element and its context
        const canvas = document.getElementById("canvas");
        const ctx = canvas.getContext("2d");

        // Load the image
        const img = new Image();
        img.src = imgSrc;

        // Draw the image on the canvas when it loads
        img.onload = function() {
            ctx.clearRect(0, 0, canvas.width, canvas.height); // Clear the canvas
            ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
        };
        
        // Show title
        const title = document.getElementById("demoTitle");
        title.style.opacity = "0";
        title.innerHTML = '&nbsp;';
    }

    // Initial image load
    setImageSource(demoNumber);

    // Get the overlay element
    const overlay = document.getElementById("overlay");

    // Function to create 25 div elements for the overlay
    function createOverlaySquares() {
        overlay.innerHTML = ''; // Clear existing squares
        for (let i = 0; i < 25; i++) {
            const rect = document.createElement("div");
            rect.id = "rect" + (i + 1);
            overlay.appendChild(rect);
        }
    }

    createOverlaySquares(); // Initial creation of squares

    // Set to track revealed squares
    let revealedSquares = new Set();

    // Function to reveal a random square
    function revealRandomSquare() {
        if (revealedSquares.size >= 25) {
            alert("All squares have been revealed!");
            return;
        }

        let randomIndex;
        do {
            randomIndex = Math.floor(Math.random() * 25) + 1;
        } while (revealedSquares.has(randomIndex));

        revealedSquares.add(randomIndex);
        const randomRect = document.getElementById("rect" + randomIndex);
        randomRect.style.opacity = "0";
    }
    
    function revealAll() {
        for (let i = 1; i <= 25; i++) {
            const rect = document.getElementById("rect" + i);
            rect.style.opacity = "0";
        }
        const title = document.getElementById("demoTitle");
        title.style.opacity = "1";
        title.innerHTML = demoTitles[demoNumber];
    }

    // Add event listener to the reveal button
    const revealButton = document.getElementById("revealButton");
    revealButton.addEventListener("click", revealRandomSquare);

    // Function to navigate to the next demo
    function goToNextDemo() {
        
        const title = document.getElementById("demoTitle");
        title.innerHTML = '';
        
        demoNumber++;

        if (demoNumber > 30) {
            alert("No more demos available!");
            return;
        }
        nextDemoNumber = demoNumber.toString().padStart(2, '0');  // Ensure two digits

        // Reset the overlay squares
        createOverlaySquares();

        // Reset revealed squares set
        revealedSquares = new Set();

        // Set the new image source
        setImageSource(nextDemoNumber);

    }
    
    

    // Add event listener to the next demo button
    const nextDemoButton = document.getElementById("nextDemoButton");
    nextDemoButton.addEventListener("click", goToNextDemo);
    
    const revealAllButton = document.getElementById("revealAllButton");
    revealAllButton.addEventListener("click", revealAll);
});
