/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVideoEncodeH265FrameSizeEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMEISIZE;
    public static final int FRAMEPSIZE;
    public static final int FRAMEBSIZE;

    public VkVideoEncodeH265FrameSizeEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeH265FrameSizeEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int frameISize() {
        return VkVideoEncodeH265FrameSizeEXT.nframeISize(this.address());
    }

    @NativeType(value="uint32_t")
    public int framePSize() {
        return VkVideoEncodeH265FrameSizeEXT.nframePSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int frameBSize() {
        return VkVideoEncodeH265FrameSizeEXT.nframeBSize(this.address());
    }

    public VkVideoEncodeH265FrameSizeEXT frameISize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH265FrameSizeEXT.nframeISize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH265FrameSizeEXT framePSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH265FrameSizeEXT.nframePSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH265FrameSizeEXT frameBSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH265FrameSizeEXT.nframeBSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH265FrameSizeEXT set(int frameISize, int framePSize, int frameBSize) {
        this.frameISize(frameISize);
        this.framePSize(framePSize);
        this.frameBSize(frameBSize);
        return this;
    }

    public VkVideoEncodeH265FrameSizeEXT set(VkVideoEncodeH265FrameSizeEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeH265FrameSizeEXT malloc() {
        return VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoEncodeH265FrameSizeEXT calloc() {
        return VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoEncodeH265FrameSizeEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeH265FrameSizeEXT create(long address) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, address);
    }

    @Nullable
    public static VkVideoEncodeH265FrameSizeEXT createSafe(long address) {
        return address == 0L ? null : VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoEncodeH265FrameSizeEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeH265FrameSizeEXT.__create(capacity, SIZEOF);
        return VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoEncodeH265FrameSizeEXT malloc(MemoryStack stack) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoEncodeH265FrameSizeEXT calloc(MemoryStack stack) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(VkVideoEncodeH265FrameSizeEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeH265FrameSizeEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nframeISize(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEISIZE);
    }

    public static int nframePSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEPSIZE);
    }

    public static int nframeBSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEBSIZE);
    }

    public static void nframeISize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEISIZE, value);
    }

    public static void nframePSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEPSIZE, value);
    }

    public static void nframeBSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEBSIZE, value);
    }

    static {
        Struct.Layout layout = VkVideoEncodeH265FrameSizeEXT.__struct(VkVideoEncodeH265FrameSizeEXT.__member(4), VkVideoEncodeH265FrameSizeEXT.__member(4), VkVideoEncodeH265FrameSizeEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMEISIZE = layout.offsetof(0);
        FRAMEPSIZE = layout.offsetof(1);
        FRAMEBSIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeH265FrameSizeEXT, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeH265FrameSizeEXT ELEMENT_FACTORY = VkVideoEncodeH265FrameSizeEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoEncodeH265FrameSizeEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int frameISize() {
            return VkVideoEncodeH265FrameSizeEXT.nframeISize(this.address());
        }

        @NativeType(value="uint32_t")
        public int framePSize() {
            return VkVideoEncodeH265FrameSizeEXT.nframePSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int frameBSize() {
            return VkVideoEncodeH265FrameSizeEXT.nframeBSize(this.address());
        }

        public Buffer frameISize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH265FrameSizeEXT.nframeISize(this.address(), value);
            return this;
        }

        public Buffer framePSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH265FrameSizeEXT.nframePSize(this.address(), value);
            return this;
        }

        public Buffer frameBSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH265FrameSizeEXT.nframeBSize(this.address(), value);
            return this;
        }
    }
}

