/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkTransformMatrixKHR;

public class VkTransformMatrixNV
extends VkTransformMatrixKHR {
    public VkTransformMatrixNV(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkTransformMatrixNV matrix(@NativeType(value="float[3][4]") FloatBuffer value) {
        VkTransformMatrixNV.nmatrix(this.address(), value);
        return this;
    }

    @Override
    public VkTransformMatrixNV matrix(int index, float value) {
        VkTransformMatrixNV.nmatrix(this.address(), index, value);
        return this;
    }

    public VkTransformMatrixNV set(VkTransformMatrixNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkTransformMatrixNV malloc() {
        return VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkTransformMatrixNV calloc() {
        return VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkTransformMatrixNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkTransformMatrixNV create(long address) {
        return VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, address);
    }

    @Nullable
    public static VkTransformMatrixNV createSafe(long address) {
        return address == 0L ? null : VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkTransformMatrixNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkTransformMatrixNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkTransformMatrixNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkTransformMatrixNV.__create(capacity, SIZEOF);
        return VkTransformMatrixNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkTransformMatrixNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkTransformMatrixNV.wrap(Buffer.class, address, capacity);
    }

    public static VkTransformMatrixNV malloc(MemoryStack stack) {
        return VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkTransformMatrixNV calloc(MemoryStack stack) {
        return VkTransformMatrixNV.wrap(VkTransformMatrixNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkTransformMatrixNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkTransformMatrixNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkTransformMatrixKHR.Buffer {
        private static final VkTransformMatrixNV ELEMENT_FACTORY = VkTransformMatrixNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkTransformMatrixNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer matrix(@NativeType(value="float[3][4]") FloatBuffer value) {
            VkTransformMatrixNV.nmatrix(this.address(), value);
            return this;
        }

        @Override
        public Buffer matrix(int index, float value) {
            VkTransformMatrixNV.nmatrix(this.address(), index, value);
            return this;
        }
    }
}

