/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSurfaceFormatKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int COLORSPACE;

    public VkSurfaceFormatKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSurfaceFormatKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkSurfaceFormatKHR.nformat(this.address());
    }

    @NativeType(value="VkColorSpaceKHR")
    public int colorSpace() {
        return VkSurfaceFormatKHR.ncolorSpace(this.address());
    }

    public static VkSurfaceFormatKHR malloc() {
        return VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSurfaceFormatKHR calloc() {
        return VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSurfaceFormatKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSurfaceFormatKHR create(long address) {
        return VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, address);
    }

    @Nullable
    public static VkSurfaceFormatKHR createSafe(long address) {
        return address == 0L ? null : VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceFormatKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSurfaceFormatKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceFormatKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSurfaceFormatKHR.__create(capacity, SIZEOF);
        return VkSurfaceFormatKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSurfaceFormatKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSurfaceFormatKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSurfaceFormatKHR mallocStack() {
        return VkSurfaceFormatKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceFormatKHR callocStack() {
        return VkSurfaceFormatKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceFormatKHR mallocStack(MemoryStack stack) {
        return VkSurfaceFormatKHR.malloc(stack);
    }

    @Deprecated
    public static VkSurfaceFormatKHR callocStack(MemoryStack stack) {
        return VkSurfaceFormatKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSurfaceFormatKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSurfaceFormatKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormatKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceFormatKHR.calloc(capacity, stack);
    }

    public static VkSurfaceFormatKHR malloc(MemoryStack stack) {
        return VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceFormatKHR calloc(MemoryStack stack) {
        return VkSurfaceFormatKHR.wrap(VkSurfaceFormatKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSurfaceFormatKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSurfaceFormatKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int ncolorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORSPACE);
    }

    static {
        Struct.Layout layout = VkSurfaceFormatKHR.__struct(VkSurfaceFormatKHR.__member(4), VkSurfaceFormatKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        COLORSPACE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceFormatKHR, Buffer>
    implements NativeResource {
        private static final VkSurfaceFormatKHR ELEMENT_FACTORY = VkSurfaceFormatKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSurfaceFormatKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkSurfaceFormatKHR.nformat(this.address());
        }

        @NativeType(value="VkColorSpaceKHR")
        public int colorSpace() {
            return VkSurfaceFormatKHR.ncolorSpace(this.address());
        }
    }
}

