/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkStridedDeviceAddressRegionKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int STRIDE;
    public static final int SIZE;

    public VkStridedDeviceAddressRegionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkStridedDeviceAddressRegionKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long stride() {
        return VkStridedDeviceAddressRegionKHR.nstride(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkStridedDeviceAddressRegionKHR.nsize(this.address());
    }

    public VkStridedDeviceAddressRegionKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR stride(@NativeType(value="VkDeviceSize") long value) {
        VkStridedDeviceAddressRegionKHR.nstride(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR size(@NativeType(value="VkDeviceSize") long value) {
        VkStridedDeviceAddressRegionKHR.nsize(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR set(long deviceAddress, long stride, long size) {
        this.deviceAddress(deviceAddress);
        this.stride(stride);
        this.size(size);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR set(VkStridedDeviceAddressRegionKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkStridedDeviceAddressRegionKHR malloc() {
        return VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkStridedDeviceAddressRegionKHR calloc() {
        return VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkStridedDeviceAddressRegionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkStridedDeviceAddressRegionKHR create(long address) {
        return VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, address);
    }

    @Nullable
    public static VkStridedDeviceAddressRegionKHR createSafe(long address) {
        return address == 0L ? null : VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkStridedDeviceAddressRegionKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkStridedDeviceAddressRegionKHR.__create(capacity, SIZEOF);
        return VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkStridedDeviceAddressRegionKHR malloc(MemoryStack stack) {
        return VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkStridedDeviceAddressRegionKHR calloc(MemoryStack stack) {
        return VkStridedDeviceAddressRegionKHR.wrap(VkStridedDeviceAddressRegionKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkStridedDeviceAddressRegionKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static long nstride(long struct) {
        return UNSAFE.getLong(null, struct + (long)STRIDE);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    public static void nstride(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)STRIDE, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkStridedDeviceAddressRegionKHR.__struct(VkStridedDeviceAddressRegionKHR.__member(8), VkStridedDeviceAddressRegionKHR.__member(8), VkStridedDeviceAddressRegionKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkStridedDeviceAddressRegionKHR, Buffer>
    implements NativeResource {
        private static final VkStridedDeviceAddressRegionKHR ELEMENT_FACTORY = VkStridedDeviceAddressRegionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkStridedDeviceAddressRegionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long stride() {
            return VkStridedDeviceAddressRegionKHR.nstride(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkStridedDeviceAddressRegionKHR.nsize(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="VkDeviceSize") long value) {
            VkStridedDeviceAddressRegionKHR.nstride(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkStridedDeviceAddressRegionKHR.nsize(this.address(), value);
            return this;
        }
    }
}

