/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageFormatProperties;

public class VkSparseImageMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMATPROPERTIES;
    public static final int IMAGEMIPTAILFIRSTLOD;
    public static final int IMAGEMIPTAILSIZE;
    public static final int IMAGEMIPTAILOFFSET;
    public static final int IMAGEMIPTAILSTRIDE;

    public VkSparseImageMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSparseImageMemoryRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkSparseImageFormatProperties formatProperties() {
        return VkSparseImageMemoryRequirements.nformatProperties(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageMipTailFirstLod() {
        return VkSparseImageMemoryRequirements.nimageMipTailFirstLod(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long imageMipTailSize() {
        return VkSparseImageMemoryRequirements.nimageMipTailSize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long imageMipTailOffset() {
        return VkSparseImageMemoryRequirements.nimageMipTailOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long imageMipTailStride() {
        return VkSparseImageMemoryRequirements.nimageMipTailStride(this.address());
    }

    public static VkSparseImageMemoryRequirements malloc() {
        return VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseImageMemoryRequirements calloc() {
        return VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSparseImageMemoryRequirements create(long address) {
        return VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, address);
    }

    @Nullable
    public static VkSparseImageMemoryRequirements createSafe(long address) {
        return address == 0L ? null : VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageMemoryRequirements.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSparseImageMemoryRequirements.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageMemoryRequirements.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryRequirements.__create(capacity, SIZEOF);
        return VkSparseImageMemoryRequirements.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSparseImageMemoryRequirements.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseImageMemoryRequirements.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements mallocStack() {
        return VkSparseImageMemoryRequirements.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements callocStack() {
        return VkSparseImageMemoryRequirements.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.malloc(stack);
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements callocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryRequirements.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryRequirements.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.calloc(capacity, stack);
    }

    public static VkSparseImageMemoryRequirements malloc(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements calloc(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkSparseImageFormatProperties nformatProperties(long struct) {
        return VkSparseImageFormatProperties.create(struct + (long)FORMATPROPERTIES);
    }

    public static int nimageMipTailFirstLod(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEMIPTAILFIRSTLOD);
    }

    public static long nimageMipTailSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEMIPTAILSIZE);
    }

    public static long nimageMipTailOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEMIPTAILOFFSET);
    }

    public static long nimageMipTailStride(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEMIPTAILSTRIDE);
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryRequirements.__struct(VkSparseImageMemoryRequirements.__member(VkSparseImageFormatProperties.SIZEOF, VkSparseImageFormatProperties.ALIGNOF), VkSparseImageMemoryRequirements.__member(4), VkSparseImageMemoryRequirements.__member(8), VkSparseImageMemoryRequirements.__member(8), VkSparseImageMemoryRequirements.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMATPROPERTIES = layout.offsetof(0);
        IMAGEMIPTAILFIRSTLOD = layout.offsetof(1);
        IMAGEMIPTAILSIZE = layout.offsetof(2);
        IMAGEMIPTAILOFFSET = layout.offsetof(3);
        IMAGEMIPTAILSTRIDE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkSparseImageMemoryRequirements ELEMENT_FACTORY = VkSparseImageMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSparseImageMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkSparseImageFormatProperties formatProperties() {
            return VkSparseImageMemoryRequirements.nformatProperties(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageMipTailFirstLod() {
            return VkSparseImageMemoryRequirements.nimageMipTailFirstLod(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long imageMipTailSize() {
            return VkSparseImageMemoryRequirements.nimageMipTailSize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long imageMipTailOffset() {
            return VkSparseImageMemoryRequirements.nimageMipTailOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long imageMipTailStride() {
            return VkSparseImageMemoryRequirements.nimageMipTailStride(this.address());
        }
    }
}

