/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageResolve2;

public class VkResolveImageInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    public VkResolveImageInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkResolveImageInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkResolveImageInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkResolveImageInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkResolveImageInfo2.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkResolveImageInfo2.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkResolveImageInfo2.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkResolveImageInfo2.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkResolveImageInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkImageResolve2 const *")
    public VkImageResolve2.Buffer pRegions() {
        return VkResolveImageInfo2.npRegions(this.address());
    }

    public VkResolveImageInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkResolveImageInfo2.nsType(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 sType$Default() {
        return this.sType(1000337005);
    }

    public VkResolveImageInfo2 pNext(@NativeType(value="void const *") long value) {
        VkResolveImageInfo2.npNext(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 srcImage(@NativeType(value="VkImage") long value) {
        VkResolveImageInfo2.nsrcImage(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkResolveImageInfo2.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 dstImage(@NativeType(value="VkImage") long value) {
        VkResolveImageInfo2.ndstImage(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkResolveImageInfo2.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 pRegions(@NativeType(value="VkImageResolve2 const *") VkImageResolve2.Buffer value) {
        VkResolveImageInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 set(int sType, long pNext, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageResolve2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkResolveImageInfo2 set(VkResolveImageInfo2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkResolveImageInfo2 malloc() {
        return VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkResolveImageInfo2 calloc() {
        return VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkResolveImageInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, MemoryUtil.memAddress(container), container);
    }

    public static VkResolveImageInfo2 create(long address) {
        return VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, address);
    }

    @Nullable
    public static VkResolveImageInfo2 createSafe(long address) {
        return address == 0L ? null : VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkResolveImageInfo2.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkResolveImageInfo2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkResolveImageInfo2.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkResolveImageInfo2.__create(capacity, SIZEOF);
        return VkResolveImageInfo2.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkResolveImageInfo2.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkResolveImageInfo2.wrap(Buffer.class, address, capacity);
    }

    public static VkResolveImageInfo2 malloc(MemoryStack stack) {
        return VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkResolveImageInfo2 calloc(MemoryStack stack) {
        return VkResolveImageInfo2.wrap(VkResolveImageInfo2.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkResolveImageInfo2.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkResolveImageInfo2.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrcImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCIMAGE);
    }

    public static int nsrcImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCIMAGELAYOUT);
    }

    public static long ndstImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTIMAGE);
    }

    public static int ndstImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTIMAGELAYOUT);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkImageResolve2.Buffer npRegions(long struct) {
        return VkImageResolve2.create(MemoryUtil.memGetAddress(struct + (long)PREGIONS), VkResolveImageInfo2.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCIMAGE, value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCIMAGELAYOUT, value);
    }

    public static void ndstImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTIMAGE, value);
    }

    public static void ndstImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTIMAGELAYOUT, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkImageResolve2.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREGIONS, value.address());
        VkResolveImageInfo2.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PREGIONS));
    }

    static {
        Struct.Layout layout = VkResolveImageInfo2.__struct(VkResolveImageInfo2.__member(4), VkResolveImageInfo2.__member(POINTER_SIZE), VkResolveImageInfo2.__member(8), VkResolveImageInfo2.__member(4), VkResolveImageInfo2.__member(8), VkResolveImageInfo2.__member(4), VkResolveImageInfo2.__member(4), VkResolveImageInfo2.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCIMAGE = layout.offsetof(2);
        SRCIMAGELAYOUT = layout.offsetof(3);
        DSTIMAGE = layout.offsetof(4);
        DSTIMAGELAYOUT = layout.offsetof(5);
        REGIONCOUNT = layout.offsetof(6);
        PREGIONS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkResolveImageInfo2, Buffer>
    implements NativeResource {
        private static final VkResolveImageInfo2 ELEMENT_FACTORY = VkResolveImageInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkResolveImageInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkResolveImageInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkResolveImageInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkResolveImageInfo2.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkResolveImageInfo2.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkResolveImageInfo2.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkResolveImageInfo2.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkResolveImageInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkImageResolve2 const *")
        public VkImageResolve2.Buffer pRegions() {
            return VkResolveImageInfo2.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkResolveImageInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkResolveImageInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkResolveImageInfo2.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkResolveImageInfo2.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkResolveImageInfo2.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkResolveImageInfo2.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageResolve2 const *") VkImageResolve2.Buffer value) {
            VkResolveImageInfo2.npRegions(this.address(), value);
            return this;
        }
    }
}

