/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderPassAttachmentBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;

    public VkRenderPassAttachmentBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderPassAttachmentBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassAttachmentBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassAttachmentBeginInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassAttachmentBeginInfo.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageView const *")
    public LongBuffer pAttachments() {
        return VkRenderPassAttachmentBeginInfo.npAttachments(this.address());
    }

    public VkRenderPassAttachmentBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassAttachmentBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo sType$Default() {
        return this.sType(1000108003);
    }

    public VkRenderPassAttachmentBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassAttachmentBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
        VkRenderPassAttachmentBeginInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo set(int sType, long pNext, @Nullable LongBuffer pAttachments) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttachments(pAttachments);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo set(VkRenderPassAttachmentBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassAttachmentBeginInfo malloc() {
        return VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderPassAttachmentBeginInfo calloc() {
        return VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderPassAttachmentBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkRenderPassAttachmentBeginInfo create(long address) {
        return VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, address);
    }

    @Nullable
    public static VkRenderPassAttachmentBeginInfo createSafe(long address) {
        return address == 0L ? null : VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkRenderPassAttachmentBeginInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassAttachmentBeginInfo.__create(capacity, SIZEOF);
        return VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkRenderPassAttachmentBeginInfo malloc(MemoryStack stack) {
        return VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassAttachmentBeginInfo calloc(MemoryStack stack) {
        return VkRenderPassAttachmentBeginInfo.wrap(VkRenderPassAttachmentBeginInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkRenderPassAttachmentBeginInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static LongBuffer npAttachments(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS), VkRenderPassAttachmentBeginInfo.nattachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkRenderPassAttachmentBeginInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassAttachmentBeginInfo.nattachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassAttachmentBeginInfo.__struct(VkRenderPassAttachmentBeginInfo.__member(4), VkRenderPassAttachmentBeginInfo.__member(POINTER_SIZE), VkRenderPassAttachmentBeginInfo.__member(4), VkRenderPassAttachmentBeginInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENTCOUNT = layout.offsetof(2);
        PATTACHMENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassAttachmentBeginInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassAttachmentBeginInfo ELEMENT_FACTORY = VkRenderPassAttachmentBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderPassAttachmentBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassAttachmentBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassAttachmentBeginInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassAttachmentBeginInfo.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageView const *")
        public LongBuffer pAttachments() {
            return VkRenderPassAttachmentBeginInfo.npAttachments(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassAttachmentBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000108003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassAttachmentBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
            VkRenderPassAttachmentBeginInfo.npAttachments(this.address(), value);
            return this;
        }
    }
}

