/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPresentIdKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SWAPCHAINCOUNT;
    public static final int PPRESENTIDS;

    public VkPresentIdKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPresentIdKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPresentIdKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPresentIdKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int swapchainCount() {
        return VkPresentIdKHR.nswapchainCount(this.address());
    }

    @Nullable
    @NativeType(value="uint64_t const *")
    public LongBuffer pPresentIds() {
        return VkPresentIdKHR.npPresentIds(this.address());
    }

    public VkPresentIdKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPresentIdKHR.nsType(this.address(), value);
        return this;
    }

    public VkPresentIdKHR sType$Default() {
        return this.sType(1000294000);
    }

    public VkPresentIdKHR pNext(@NativeType(value="void const *") long value) {
        VkPresentIdKHR.npNext(this.address(), value);
        return this;
    }

    public VkPresentIdKHR swapchainCount(@NativeType(value="uint32_t") int value) {
        VkPresentIdKHR.nswapchainCount(this.address(), value);
        return this;
    }

    public VkPresentIdKHR pPresentIds(@Nullable @NativeType(value="uint64_t const *") LongBuffer value) {
        VkPresentIdKHR.npPresentIds(this.address(), value);
        return this;
    }

    public VkPresentIdKHR set(int sType, long pNext, int swapchainCount, @Nullable LongBuffer pPresentIds) {
        this.sType(sType);
        this.pNext(pNext);
        this.swapchainCount(swapchainCount);
        this.pPresentIds(pPresentIds);
        return this;
    }

    public VkPresentIdKHR set(VkPresentIdKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPresentIdKHR malloc() {
        return VkPresentIdKHR.wrap(VkPresentIdKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPresentIdKHR calloc() {
        return VkPresentIdKHR.wrap(VkPresentIdKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPresentIdKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPresentIdKHR.wrap(VkPresentIdKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPresentIdKHR create(long address) {
        return VkPresentIdKHR.wrap(VkPresentIdKHR.class, address);
    }

    @Nullable
    public static VkPresentIdKHR createSafe(long address) {
        return address == 0L ? null : VkPresentIdKHR.wrap(VkPresentIdKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPresentIdKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPresentIdKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPresentIdKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPresentIdKHR.__create(capacity, SIZEOF);
        return VkPresentIdKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPresentIdKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPresentIdKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkPresentIdKHR malloc(MemoryStack stack) {
        return VkPresentIdKHR.wrap(VkPresentIdKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPresentIdKHR calloc(MemoryStack stack) {
        return VkPresentIdKHR.wrap(VkPresentIdKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPresentIdKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPresentIdKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nswapchainCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SWAPCHAINCOUNT);
    }

    @Nullable
    public static LongBuffer npPresentIds(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPRESENTIDS), VkPresentIdKHR.nswapchainCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nswapchainCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SWAPCHAINCOUNT, value);
    }

    public static void npPresentIds(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPRESENTIDS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPresentIdKHR.nswapchainCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPresentIdKHR.__struct(VkPresentIdKHR.__member(4), VkPresentIdKHR.__member(POINTER_SIZE), VkPresentIdKHR.__member(4), VkPresentIdKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SWAPCHAINCOUNT = layout.offsetof(2);
        PPRESENTIDS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPresentIdKHR, Buffer>
    implements NativeResource {
        private static final VkPresentIdKHR ELEMENT_FACTORY = VkPresentIdKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPresentIdKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPresentIdKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPresentIdKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int swapchainCount() {
            return VkPresentIdKHR.nswapchainCount(this.address());
        }

        @Nullable
        @NativeType(value="uint64_t const *")
        public LongBuffer pPresentIds() {
            return VkPresentIdKHR.npPresentIds(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPresentIdKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000294000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPresentIdKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer swapchainCount(@NativeType(value="uint32_t") int value) {
            VkPresentIdKHR.nswapchainCount(this.address(), value);
            return this;
        }

        public Buffer pPresentIds(@Nullable @NativeType(value="uint64_t const *") LongBuffer value) {
            VkPresentIdKHR.npPresentIds(this.address(), value);
            return this;
        }
    }
}

