/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkViewportSwizzleNV;

public class VkPipelineViewportSwizzleStateCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int VIEWPORTCOUNT;
    public static final int PVIEWPORTSWIZZLES;

    public VkPipelineViewportSwizzleStateCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineViewportSwizzleStateCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkPipelineViewportSwizzleStateCreateFlagsNV")
    public int flags() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewportCount() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(this.address());
    }

    @NativeType(value="VkViewportSwizzleNV const *")
    public VkViewportSwizzleNV.Buffer pViewportSwizzles() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address());
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV sType$Default() {
        return this.sType(1000098000);
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV flags(@NativeType(value="VkPipelineViewportSwizzleStateCreateFlagsNV") int value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV pViewportSwizzles(@NativeType(value="VkViewportSwizzleNV const *") VkViewportSwizzleNV.Buffer value) {
        VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address(), value);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV set(int sType, long pNext, int flags, VkViewportSwizzleNV.Buffer pViewportSwizzles) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pViewportSwizzles(pViewportSwizzles);
        return this;
    }

    public VkPipelineViewportSwizzleStateCreateInfoNV set(VkPipelineViewportSwizzleStateCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV malloc() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV calloc() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV create(long address) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, address);
    }

    @Nullable
    public static VkPipelineViewportSwizzleStateCreateInfoNV createSafe(long address) {
        return address == 0L ? null : VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineViewportSwizzleStateCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineViewportSwizzleStateCreateInfoNV.__create(capacity, SIZEOF);
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPipelineViewportSwizzleStateCreateInfoNV mallocStack() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineViewportSwizzleStateCreateInfoNV callocStack() {
        return VkPipelineViewportSwizzleStateCreateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineViewportSwizzleStateCreateInfoNV mallocStack(MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkPipelineViewportSwizzleStateCreateInfoNV callocStack(MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.calloc(capacity, stack);
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV malloc(MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineViewportSwizzleStateCreateInfoNV calloc(MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(VkPipelineViewportSwizzleStateCreateInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineViewportSwizzleStateCreateInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nviewportCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWPORTCOUNT);
    }

    public static VkViewportSwizzleNV.Buffer npViewportSwizzles(long struct) {
        return VkViewportSwizzleNV.create(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTSWIZZLES), VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nviewportCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWPORTCOUNT, value);
    }

    public static void npViewportSwizzles(long struct, VkViewportSwizzleNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTSWIZZLES, value.address());
        VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTSWIZZLES));
    }

    static {
        Struct.Layout layout = VkPipelineViewportSwizzleStateCreateInfoNV.__struct(VkPipelineViewportSwizzleStateCreateInfoNV.__member(4), VkPipelineViewportSwizzleStateCreateInfoNV.__member(POINTER_SIZE), VkPipelineViewportSwizzleStateCreateInfoNV.__member(4), VkPipelineViewportSwizzleStateCreateInfoNV.__member(4), VkPipelineViewportSwizzleStateCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        VIEWPORTCOUNT = layout.offsetof(3);
        PVIEWPORTSWIZZLES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineViewportSwizzleStateCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkPipelineViewportSwizzleStateCreateInfoNV ELEMENT_FACTORY = VkPipelineViewportSwizzleStateCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineViewportSwizzleStateCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkPipelineViewportSwizzleStateCreateFlagsNV")
        public int flags() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewportCount() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.nviewportCount(this.address());
        }

        @NativeType(value="VkViewportSwizzleNV const *")
        public VkViewportSwizzleNV.Buffer pViewportSwizzles() {
            return VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000098000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineViewportSwizzleStateCreateFlagsNV") int value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer pViewportSwizzles(@NativeType(value="VkViewportSwizzleNV const *") VkViewportSwizzleNV.Buffer value) {
            VkPipelineViewportSwizzleStateCreateInfoNV.npViewportSwizzles(this.address(), value);
            return this;
        }
    }
}

