/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineCacheHeaderVersionOne
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADERSIZE;
    public static final int HEADERVERSION;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int PIPELINECACHEUUID;

    public VkPipelineCacheHeaderVersionOne(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineCacheHeaderVersionOne.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int headerSize() {
        return VkPipelineCacheHeaderVersionOne.nheaderSize(this.address());
    }

    @NativeType(value="VkPipelineCacheHeaderVersion")
    public int headerVersion() {
        return VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorID() {
        return VkPipelineCacheHeaderVersionOne.nvendorID(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceID() {
        return VkPipelineCacheHeaderVersionOne.ndeviceID(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer pipelineCacheUUID() {
        return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pipelineCacheUUID(int index) {
        return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index);
    }

    public VkPipelineCacheHeaderVersionOne headerSize(@NativeType(value="uint32_t") int value) {
        VkPipelineCacheHeaderVersionOne.nheaderSize(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne headerVersion(@NativeType(value="VkPipelineCacheHeaderVersion") int value) {
        VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne vendorID(@NativeType(value="uint32_t") int value) {
        VkPipelineCacheHeaderVersionOne.nvendorID(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne deviceID(@NativeType(value="uint32_t") int value) {
        VkPipelineCacheHeaderVersionOne.ndeviceID(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne pipelineCacheUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
        VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne pipelineCacheUUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index, value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne set(int headerSize, int headerVersion, int vendorID, int deviceID, ByteBuffer pipelineCacheUUID) {
        this.headerSize(headerSize);
        this.headerVersion(headerVersion);
        this.vendorID(vendorID);
        this.deviceID(deviceID);
        this.pipelineCacheUUID(pipelineCacheUUID);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne set(VkPipelineCacheHeaderVersionOne src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineCacheHeaderVersionOne malloc() {
        return VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineCacheHeaderVersionOne calloc() {
        return VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineCacheHeaderVersionOne create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineCacheHeaderVersionOne create(long address) {
        return VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, address);
    }

    @Nullable
    public static VkPipelineCacheHeaderVersionOne createSafe(long address) {
        return address == 0L ? null : VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineCacheHeaderVersionOne.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineCacheHeaderVersionOne.__create(capacity, SIZEOF);
        return VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, address, capacity);
    }

    public static VkPipelineCacheHeaderVersionOne malloc(MemoryStack stack) {
        return VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineCacheHeaderVersionOne calloc(MemoryStack stack) {
        return VkPipelineCacheHeaderVersionOne.wrap(VkPipelineCacheHeaderVersionOne.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineCacheHeaderVersionOne.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nheaderSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEADERSIZE);
    }

    public static int nheaderVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEADERVERSION);
    }

    public static int nvendorID(long struct) {
        return UNSAFE.getInt(null, struct + (long)VENDORID);
    }

    public static int ndeviceID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEID);
    }

    public static ByteBuffer npipelineCacheUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)PIPELINECACHEUUID, 16);
    }

    public static byte npipelineCacheUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)PIPELINECACHEUUID + Checks.check(index, 16) * 1L);
    }

    public static void nheaderSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEADERSIZE, value);
    }

    public static void nheaderVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEADERVERSION, value);
    }

    public static void nvendorID(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VENDORID, value);
    }

    public static void ndeviceID(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEID, value);
    }

    public static void npipelineCacheUUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PIPELINECACHEUUID, value.remaining() * 1);
    }

    public static void npipelineCacheUUID(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)PIPELINECACHEUUID + Checks.check(index, 16) * 1L, value);
    }

    static {
        Struct.Layout layout = VkPipelineCacheHeaderVersionOne.__struct(VkPipelineCacheHeaderVersionOne.__member(4), VkPipelineCacheHeaderVersionOne.__member(4), VkPipelineCacheHeaderVersionOne.__member(4), VkPipelineCacheHeaderVersionOne.__member(4), VkPipelineCacheHeaderVersionOne.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADERSIZE = layout.offsetof(0);
        HEADERVERSION = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        PIPELINECACHEUUID = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineCacheHeaderVersionOne, Buffer>
    implements NativeResource {
        private static final VkPipelineCacheHeaderVersionOne ELEMENT_FACTORY = VkPipelineCacheHeaderVersionOne.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineCacheHeaderVersionOne getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int headerSize() {
            return VkPipelineCacheHeaderVersionOne.nheaderSize(this.address());
        }

        @NativeType(value="VkPipelineCacheHeaderVersion")
        public int headerVersion() {
            return VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorID() {
            return VkPipelineCacheHeaderVersionOne.nvendorID(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceID() {
            return VkPipelineCacheHeaderVersionOne.ndeviceID(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer pipelineCacheUUID() {
            return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pipelineCacheUUID(int index) {
            return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index);
        }

        public Buffer headerSize(@NativeType(value="uint32_t") int value) {
            VkPipelineCacheHeaderVersionOne.nheaderSize(this.address(), value);
            return this;
        }

        public Buffer headerVersion(@NativeType(value="VkPipelineCacheHeaderVersion") int value) {
            VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address(), value);
            return this;
        }

        public Buffer vendorID(@NativeType(value="uint32_t") int value) {
            VkPipelineCacheHeaderVersionOne.nvendorID(this.address(), value);
            return this;
        }

        public Buffer deviceID(@NativeType(value="uint32_t") int value) {
            VkPipelineCacheHeaderVersionOne.ndeviceID(this.address(), value);
            return this;
        }

        public Buffer pipelineCacheUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
            VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), value);
            return this;
        }

        public Buffer pipelineCacheUUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index, value);
            return this;
        }
    }
}

