/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPhysicalDeviceVariablePointersFeatures;

public class VkPhysicalDeviceVariablePointerFeatures
extends VkPhysicalDeviceVariablePointersFeatures {
    public VkPhysicalDeviceVariablePointerFeatures(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceVariablePointerFeatures.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures sType$Default() {
        return this.sType(1000120000);
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceVariablePointerFeatures.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures variablePointersStorageBuffer(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVariablePointerFeatures.nvariablePointersStorageBuffer(this.address(), value ? 1 : 0);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures variablePointers(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVariablePointerFeatures.nvariablePointers(this.address(), value ? 1 : 0);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures set(int sType, long pNext, boolean variablePointersStorageBuffer, boolean variablePointers) {
        this.sType(sType);
        this.pNext(pNext);
        this.variablePointersStorageBuffer(variablePointersStorageBuffer);
        this.variablePointers(variablePointers);
        return this;
    }

    public VkPhysicalDeviceVariablePointerFeatures set(VkPhysicalDeviceVariablePointerFeatures src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceVariablePointerFeatures malloc() {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceVariablePointerFeatures calloc() {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceVariablePointerFeatures create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceVariablePointerFeatures create(long address) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, address);
    }

    @Nullable
    public static VkPhysicalDeviceVariablePointerFeatures createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPhysicalDeviceVariablePointerFeatures.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceVariablePointerFeatures.__create(capacity, SIZEOF);
        return VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures mallocStack() {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures callocStack() {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures callocStack(MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceVariablePointerFeatures malloc(MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceVariablePointerFeatures calloc(MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPhysicalDeviceVariablePointersFeatures.Buffer {
        private static final VkPhysicalDeviceVariablePointerFeatures ELEMENT_FACTORY = VkPhysicalDeviceVariablePointerFeatures.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceVariablePointerFeatures getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceVariablePointerFeatures.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000120000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceVariablePointerFeatures.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer variablePointersStorageBuffer(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVariablePointerFeatures.nvariablePointersStorageBuffer(this.address(), value ? 1 : 0);
            return this;
        }

        @Override
        public Buffer variablePointers(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVariablePointerFeatures.nvariablePointers(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

