/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHeap
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;

    public VkMemoryHeap(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryHeap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryHeap.nsize(this.address());
    }

    @NativeType(value="VkMemoryHeapFlags")
    public int flags() {
        return VkMemoryHeap.nflags(this.address());
    }

    public static VkMemoryHeap create(long address) {
        return VkMemoryHeap.wrap(VkMemoryHeap.class, address);
    }

    @Nullable
    public static VkMemoryHeap createSafe(long address) {
        return address == 0L ? null : VkMemoryHeap.wrap(VkMemoryHeap.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryHeap.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryHeap.wrap(Buffer.class, address, capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkMemoryHeap.__struct(VkMemoryHeap.__member(8), VkMemoryHeap.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHeap, Buffer> {
        private static final VkMemoryHeap ELEMENT_FACTORY = VkMemoryHeap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryHeap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryHeap.nsize(this.address());
        }

        @NativeType(value="VkMemoryHeapFlags")
        public int flags() {
            return VkMemoryHeap.nflags(this.address());
        }
    }
}

