/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfo;

public class VkMemoryDedicatedAllocateInfoKHR
extends VkMemoryDedicatedAllocateInfo {
    public VkMemoryDedicatedAllocateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR sType$Default() {
        return this.sType(1000127001);
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryDedicatedAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR image(@NativeType(value="VkImage") long value) {
        VkMemoryDedicatedAllocateInfoKHR.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkMemoryDedicatedAllocateInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR set(int sType, long pNext, long image, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.buffer(buffer);
        return this;
    }

    public VkMemoryDedicatedAllocateInfoKHR set(VkMemoryDedicatedAllocateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedAllocateInfoKHR malloc() {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR calloc() {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryDedicatedAllocateInfoKHR create(long address) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, address);
    }

    @Nullable
    public static VkMemoryDedicatedAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryDedicatedAllocateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryDedicatedAllocateInfoKHR.__create(capacity, SIZEOF);
        return VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR mallocStack() {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR callocStack() {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(capacity, stack);
    }

    public static VkMemoryDedicatedAllocateInfoKHR malloc(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryDedicatedAllocateInfoKHR calloc(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(VkMemoryDedicatedAllocateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryDedicatedAllocateInfo.Buffer {
        private static final VkMemoryDedicatedAllocateInfoKHR ELEMENT_FACTORY = VkMemoryDedicatedAllocateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryDedicatedAllocateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000127001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryDedicatedAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkMemoryDedicatedAllocateInfoKHR.nimage(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkMemoryDedicatedAllocateInfoKHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

