/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkInputAttachmentAspectReference;

public class VkInputAttachmentAspectReferenceKHR
extends VkInputAttachmentAspectReference {
    public VkInputAttachmentAspectReferenceKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR subpass(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReferenceKHR.nsubpass(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReferenceKHR.ninputAttachmentIndex(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkInputAttachmentAspectReferenceKHR.naspectMask(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR set(int subpass, int inputAttachmentIndex, int aspectMask) {
        this.subpass(subpass);
        this.inputAttachmentIndex(inputAttachmentIndex);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkInputAttachmentAspectReferenceKHR set(VkInputAttachmentAspectReferenceKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkInputAttachmentAspectReferenceKHR malloc() {
        return VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR calloc() {
        return VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkInputAttachmentAspectReferenceKHR create(long address) {
        return VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, address);
    }

    @Nullable
    public static VkInputAttachmentAspectReferenceKHR createSafe(long address) {
        return address == 0L ? null : VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkInputAttachmentAspectReferenceKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkInputAttachmentAspectReferenceKHR.__create(capacity, SIZEOF);
        return VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkInputAttachmentAspectReferenceKHR mallocStack() {
        return VkInputAttachmentAspectReferenceKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkInputAttachmentAspectReferenceKHR callocStack() {
        return VkInputAttachmentAspectReferenceKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkInputAttachmentAspectReferenceKHR mallocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.malloc(stack);
    }

    @Deprecated
    public static VkInputAttachmentAspectReferenceKHR callocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.calloc(capacity, stack);
    }

    public static VkInputAttachmentAspectReferenceKHR malloc(MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR calloc(MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.wrap(VkInputAttachmentAspectReferenceKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkInputAttachmentAspectReference.Buffer {
        private static final VkInputAttachmentAspectReferenceKHR ELEMENT_FACTORY = VkInputAttachmentAspectReferenceKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkInputAttachmentAspectReferenceKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReferenceKHR.nsubpass(this.address(), value);
            return this;
        }

        @Override
        public Buffer inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReferenceKHR.ninputAttachmentIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkInputAttachmentAspectReferenceKHR.naspectMask(this.address(), value);
            return this;
        }
    }
}

