/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryWin32HandleInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int HANDLE;

    public VkImportMemoryWin32HandleInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImportMemoryWin32HandleInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int handleType() {
        return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
    }

    @NativeType(value="HANDLE")
    public long handle() {
        return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
    }

    public VkImportMemoryWin32HandleInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV sType$Default() {
        return this.sType(1000057000);
    }

    public VkImportMemoryWin32HandleInfoNV pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
        VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV handle(@NativeType(value="HANDLE") long value) {
        VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(int sType, long pNext, int handleType, long handle) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.handle(handle);
        return this;
    }

    public VkImportMemoryWin32HandleInfoNV set(VkImportMemoryWin32HandleInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMemoryWin32HandleInfoNV malloc() {
        return VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV calloc() {
        return VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImportMemoryWin32HandleInfoNV create(long address) {
        return VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, address);
    }

    @Nullable
    public static VkImportMemoryWin32HandleInfoNV createSafe(long address) {
        return address == 0L ? null : VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImportMemoryWin32HandleInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMemoryWin32HandleInfoNV.__create(capacity, SIZEOF);
        return VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV mallocStack() {
        return VkImportMemoryWin32HandleInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV callocStack() {
        return VkImportMemoryWin32HandleInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV mallocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoNV callocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.calloc(capacity, stack);
    }

    public static VkImportMemoryWin32HandleInfoNV malloc(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportMemoryWin32HandleInfoNV calloc(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.wrap(VkImportMemoryWin32HandleInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    static {
        Struct.Layout layout = VkImportMemoryWin32HandleInfoNV.__struct(VkImportMemoryWin32HandleInfoNV.__member(4), VkImportMemoryWin32HandleInfoNV.__member(POINTER_SIZE), VkImportMemoryWin32HandleInfoNV.__member(4), VkImportMemoryWin32HandleInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryWin32HandleInfoNV, Buffer>
    implements NativeResource {
        private static final VkImportMemoryWin32HandleInfoNV ELEMENT_FACTORY = VkImportMemoryWin32HandleInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImportMemoryWin32HandleInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryWin32HandleInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryWin32HandleInfoNV.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int handleType() {
            return VkImportMemoryWin32HandleInfoNV.nhandleType(this.address());
        }

        @NativeType(value="HANDLE")
        public long handle() {
            return VkImportMemoryWin32HandleInfoNV.nhandle(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryWin32HandleInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000057000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryWin32HandleInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
            VkImportMemoryWin32HandleInfoNV.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="HANDLE") long value) {
            VkImportMemoryWin32HandleInfoNV.nhandle(this.address(), value);
            return this;
        }
    }
}

