/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageBlit
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSETS;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSETS;

    public VkImageBlit(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageBlit.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageBlit.nsrcSubresource(this.address());
    }

    @NativeType(value="VkOffset3D[2]")
    public VkOffset3D.Buffer srcOffsets() {
        return VkImageBlit.nsrcOffsets(this.address());
    }

    public VkOffset3D srcOffsets(int index) {
        return VkImageBlit.nsrcOffsets(this.address(), index);
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageBlit.ndstSubresource(this.address());
    }

    @NativeType(value="VkOffset3D[2]")
    public VkOffset3D.Buffer dstOffsets() {
        return VkImageBlit.ndstOffsets(this.address());
    }

    public VkOffset3D dstOffsets(int index) {
        return VkImageBlit.ndstOffsets(this.address(), index);
    }

    public VkImageBlit srcSubresource(VkImageSubresourceLayers value) {
        VkImageBlit.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageBlit srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.srcSubresource());
        return this;
    }

    public VkImageBlit srcOffsets(@NativeType(value="VkOffset3D[2]") VkOffset3D.Buffer value) {
        VkImageBlit.nsrcOffsets(this.address(), value);
        return this;
    }

    public VkImageBlit srcOffsets(int index, VkOffset3D value) {
        VkImageBlit.nsrcOffsets(this.address(), index, value);
        return this;
    }

    public VkImageBlit srcOffsets(Consumer<VkOffset3D.Buffer> consumer) {
        consumer.accept(this.srcOffsets());
        return this;
    }

    public VkImageBlit srcOffsets(int index, Consumer<VkOffset3D> consumer) {
        consumer.accept(this.srcOffsets(index));
        return this;
    }

    public VkImageBlit dstSubresource(VkImageSubresourceLayers value) {
        VkImageBlit.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageBlit dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.dstSubresource());
        return this;
    }

    public VkImageBlit dstOffsets(@NativeType(value="VkOffset3D[2]") VkOffset3D.Buffer value) {
        VkImageBlit.ndstOffsets(this.address(), value);
        return this;
    }

    public VkImageBlit dstOffsets(int index, VkOffset3D value) {
        VkImageBlit.ndstOffsets(this.address(), index, value);
        return this;
    }

    public VkImageBlit dstOffsets(Consumer<VkOffset3D.Buffer> consumer) {
        consumer.accept(this.dstOffsets());
        return this;
    }

    public VkImageBlit dstOffsets(int index, Consumer<VkOffset3D> consumer) {
        consumer.accept(this.dstOffsets(index));
        return this;
    }

    public VkImageBlit set(VkImageSubresourceLayers srcSubresource, VkOffset3D.Buffer srcOffsets, VkImageSubresourceLayers dstSubresource, VkOffset3D.Buffer dstOffsets) {
        this.srcSubresource(srcSubresource);
        this.srcOffsets(srcOffsets);
        this.dstSubresource(dstSubresource);
        this.dstOffsets(dstOffsets);
        return this;
    }

    public VkImageBlit set(VkImageBlit src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageBlit malloc() {
        return VkImageBlit.wrap(VkImageBlit.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageBlit calloc() {
        return VkImageBlit.wrap(VkImageBlit.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageBlit create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImageBlit.wrap(VkImageBlit.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImageBlit create(long address) {
        return VkImageBlit.wrap(VkImageBlit.class, address);
    }

    @Nullable
    public static VkImageBlit createSafe(long address) {
        return address == 0L ? null : VkImageBlit.wrap(VkImageBlit.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageBlit.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImageBlit.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageBlit.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageBlit.__create(capacity, SIZEOF);
        return VkImageBlit.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImageBlit.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageBlit.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImageBlit mallocStack() {
        return VkImageBlit.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageBlit callocStack() {
        return VkImageBlit.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageBlit mallocStack(MemoryStack stack) {
        return VkImageBlit.malloc(stack);
    }

    @Deprecated
    public static VkImageBlit callocStack(MemoryStack stack) {
        return VkImageBlit.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageBlit.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageBlit.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageBlit.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageBlit.calloc(capacity, stack);
    }

    public static VkImageBlit malloc(MemoryStack stack) {
        return VkImageBlit.wrap(VkImageBlit.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageBlit calloc(MemoryStack stack) {
        return VkImageBlit.wrap(VkImageBlit.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImageBlit.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImageBlit.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D.Buffer nsrcOffsets(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSETS, 2);
    }

    public static VkOffset3D nsrcOffsets(long struct, int index) {
        return VkOffset3D.create(struct + (long)SRCOFFSETS + Checks.check(index, 2) * (long)VkOffset3D.SIZEOF);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D.Buffer ndstOffsets(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSETS, 2);
    }

    public static VkOffset3D ndstOffsets(long struct, int index) {
        return VkOffset3D.create(struct + (long)DSTOFFSETS + Checks.check(index, 2) * (long)VkOffset3D.SIZEOF);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffsets(long struct, VkOffset3D.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)SRCOFFSETS, value.remaining() * VkOffset3D.SIZEOF);
    }

    public static void nsrcOffsets(long struct, int index, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCOFFSETS + Checks.check(index, 2) * (long)VkOffset3D.SIZEOF, VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffsets(long struct, VkOffset3D.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)DSTOFFSETS, value.remaining() * VkOffset3D.SIZEOF);
    }

    public static void ndstOffsets(long struct, int index, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTOFFSETS + Checks.check(index, 2) * (long)VkOffset3D.SIZEOF, VkOffset3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageBlit.__struct(VkImageBlit.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageBlit.__array(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF, 2), VkImageBlit.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageBlit.__array(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBRESOURCE = layout.offsetof(0);
        SRCOFFSETS = layout.offsetof(1);
        DSTSUBRESOURCE = layout.offsetof(2);
        DSTOFFSETS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImageBlit, Buffer>
    implements NativeResource {
        private static final VkImageBlit ELEMENT_FACTORY = VkImageBlit.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageBlit getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageBlit.nsrcSubresource(this.address());
        }

        @NativeType(value="VkOffset3D[2]")
        public VkOffset3D.Buffer srcOffsets() {
            return VkImageBlit.nsrcOffsets(this.address());
        }

        public VkOffset3D srcOffsets(int index) {
            return VkImageBlit.nsrcOffsets(this.address(), index);
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageBlit.ndstSubresource(this.address());
        }

        @NativeType(value="VkOffset3D[2]")
        public VkOffset3D.Buffer dstOffsets() {
            return VkImageBlit.ndstOffsets(this.address());
        }

        public VkOffset3D dstOffsets(int index) {
            return VkImageBlit.ndstOffsets(this.address(), index);
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageBlit.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.srcSubresource());
            return this;
        }

        public Buffer srcOffsets(@NativeType(value="VkOffset3D[2]") VkOffset3D.Buffer value) {
            VkImageBlit.nsrcOffsets(this.address(), value);
            return this;
        }

        public Buffer srcOffsets(int index, VkOffset3D value) {
            VkImageBlit.nsrcOffsets(this.address(), index, value);
            return this;
        }

        public Buffer srcOffsets(Consumer<VkOffset3D.Buffer> consumer) {
            consumer.accept(this.srcOffsets());
            return this;
        }

        public Buffer srcOffsets(int index, Consumer<VkOffset3D> consumer) {
            consumer.accept(this.srcOffsets(index));
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageBlit.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.dstSubresource());
            return this;
        }

        public Buffer dstOffsets(@NativeType(value="VkOffset3D[2]") VkOffset3D.Buffer value) {
            VkImageBlit.ndstOffsets(this.address(), value);
            return this;
        }

        public Buffer dstOffsets(int index, VkOffset3D value) {
            VkImageBlit.ndstOffsets(this.address(), index, value);
            return this;
        }

        public Buffer dstOffsets(Consumer<VkOffset3D.Buffer> consumer) {
            consumer.accept(this.dstOffsets());
            return this;
        }

        public Buffer dstOffsets(int index, Consumer<VkOffset3D> consumer) {
            consumer.accept(this.dstOffsets(index));
            return this;
        }
    }
}

