/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkPipelineTessellationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineVertexInputStateCreateInfo;

public class VkGraphicsShaderGroupCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGECOUNT;
    public static final int PSTAGES;
    public static final int PVERTEXINPUTSTATE;
    public static final int PTESSELLATIONSTATE;

    public VkGraphicsShaderGroupCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkGraphicsShaderGroupCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGraphicsShaderGroupCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGraphicsShaderGroupCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int stageCount() {
        return VkGraphicsShaderGroupCreateInfoNV.nstageCount(this.address());
    }

    @NativeType(value="VkPipelineShaderStageCreateInfo const *")
    public VkPipelineShaderStageCreateInfo.Buffer pStages() {
        return VkGraphicsShaderGroupCreateInfoNV.npStages(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineVertexInputStateCreateInfo const *")
    public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
        return VkGraphicsShaderGroupCreateInfoNV.npVertexInputState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineTessellationStateCreateInfo const *")
    public VkPipelineTessellationStateCreateInfo pTessellationState() {
        return VkGraphicsShaderGroupCreateInfoNV.npTessellationState(this.address());
    }

    public VkGraphicsShaderGroupCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkGraphicsShaderGroupCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsShaderGroupCreateInfoNV sType$Default() {
        return this.sType(1000277001);
    }

    public VkGraphicsShaderGroupCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkGraphicsShaderGroupCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsShaderGroupCreateInfoNV pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
        VkGraphicsShaderGroupCreateInfoNV.npStages(this.address(), value);
        return this;
    }

    public VkGraphicsShaderGroupCreateInfoNV pVertexInputState(@Nullable @NativeType(value="VkPipelineVertexInputStateCreateInfo const *") VkPipelineVertexInputStateCreateInfo value) {
        VkGraphicsShaderGroupCreateInfoNV.npVertexInputState(this.address(), value);
        return this;
    }

    public VkGraphicsShaderGroupCreateInfoNV pTessellationState(@Nullable @NativeType(value="VkPipelineTessellationStateCreateInfo const *") VkPipelineTessellationStateCreateInfo value) {
        VkGraphicsShaderGroupCreateInfoNV.npTessellationState(this.address(), value);
        return this;
    }

    public VkGraphicsShaderGroupCreateInfoNV set(int sType, long pNext, VkPipelineShaderStageCreateInfo.Buffer pStages, @Nullable VkPipelineVertexInputStateCreateInfo pVertexInputState, @Nullable VkPipelineTessellationStateCreateInfo pTessellationState) {
        this.sType(sType);
        this.pNext(pNext);
        this.pStages(pStages);
        this.pVertexInputState(pVertexInputState);
        this.pTessellationState(pTessellationState);
        return this;
    }

    public VkGraphicsShaderGroupCreateInfoNV set(VkGraphicsShaderGroupCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkGraphicsShaderGroupCreateInfoNV malloc() {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkGraphicsShaderGroupCreateInfoNV calloc() {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkGraphicsShaderGroupCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkGraphicsShaderGroupCreateInfoNV create(long address) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, address);
    }

    @Nullable
    public static VkGraphicsShaderGroupCreateInfoNV createSafe(long address) {
        return address == 0L ? null : VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkGraphicsShaderGroupCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGraphicsShaderGroupCreateInfoNV.__create(capacity, SIZEOF);
        return VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    public static VkGraphicsShaderGroupCreateInfoNV malloc(MemoryStack stack) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkGraphicsShaderGroupCreateInfoNV calloc(MemoryStack stack) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(VkGraphicsShaderGroupCreateInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkGraphicsShaderGroupCreateInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGECOUNT);
    }

    public static VkPipelineShaderStageCreateInfo.Buffer npStages(long struct) {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTAGES), VkGraphicsShaderGroupCreateInfoNV.nstageCount(struct));
    }

    @Nullable
    public static VkPipelineVertexInputStateCreateInfo npVertexInputState(long struct) {
        return VkPipelineVertexInputStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE));
    }

    @Nullable
    public static VkPipelineTessellationStateCreateInfo npTessellationState(long struct) {
        return VkPipelineTessellationStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PTESSELLATIONSTATE));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstageCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGECOUNT, value);
    }

    public static void npStages(long struct, VkPipelineShaderStageCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTAGES, value.address());
        VkGraphicsShaderGroupCreateInfoNV.nstageCount(struct, value.remaining());
    }

    public static void npVertexInputState(long struct, @Nullable VkPipelineVertexInputStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXINPUTSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npTessellationState(long struct, @Nullable VkPipelineTessellationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PTESSELLATIONSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        int stageCount = VkGraphicsShaderGroupCreateInfoNV.nstageCount(struct);
        long pStages = MemoryUtil.memGetAddress(struct + (long)PSTAGES);
        Checks.check(pStages);
        VkGraphicsShaderGroupCreateInfoNV.validate(pStages, stageCount, VkPipelineShaderStageCreateInfo.SIZEOF, VkPipelineShaderStageCreateInfo::validate);
        long pVertexInputState = MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE);
        if (pVertexInputState != 0L) {
            VkPipelineVertexInputStateCreateInfo.validate(pVertexInputState);
        }
    }

    static {
        Struct.Layout layout = VkGraphicsShaderGroupCreateInfoNV.__struct(VkGraphicsShaderGroupCreateInfoNV.__member(4), VkGraphicsShaderGroupCreateInfoNV.__member(POINTER_SIZE), VkGraphicsShaderGroupCreateInfoNV.__member(4), VkGraphicsShaderGroupCreateInfoNV.__member(POINTER_SIZE), VkGraphicsShaderGroupCreateInfoNV.__member(POINTER_SIZE), VkGraphicsShaderGroupCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGECOUNT = layout.offsetof(2);
        PSTAGES = layout.offsetof(3);
        PVERTEXINPUTSTATE = layout.offsetof(4);
        PTESSELLATIONSTATE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkGraphicsShaderGroupCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkGraphicsShaderGroupCreateInfoNV ELEMENT_FACTORY = VkGraphicsShaderGroupCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkGraphicsShaderGroupCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGraphicsShaderGroupCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGraphicsShaderGroupCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int stageCount() {
            return VkGraphicsShaderGroupCreateInfoNV.nstageCount(this.address());
        }

        @NativeType(value="VkPipelineShaderStageCreateInfo const *")
        public VkPipelineShaderStageCreateInfo.Buffer pStages() {
            return VkGraphicsShaderGroupCreateInfoNV.npStages(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineVertexInputStateCreateInfo const *")
        public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
            return VkGraphicsShaderGroupCreateInfoNV.npVertexInputState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineTessellationStateCreateInfo const *")
        public VkPipelineTessellationStateCreateInfo pTessellationState() {
            return VkGraphicsShaderGroupCreateInfoNV.npTessellationState(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGraphicsShaderGroupCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGraphicsShaderGroupCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
            VkGraphicsShaderGroupCreateInfoNV.npStages(this.address(), value);
            return this;
        }

        public Buffer pVertexInputState(@Nullable @NativeType(value="VkPipelineVertexInputStateCreateInfo const *") VkPipelineVertexInputStateCreateInfo value) {
            VkGraphicsShaderGroupCreateInfoNV.npVertexInputState(this.address(), value);
            return this;
        }

        public Buffer pTessellationState(@Nullable @NativeType(value="VkPipelineTessellationStateCreateInfo const *") VkPipelineTessellationStateCreateInfo value) {
            VkGraphicsShaderGroupCreateInfoNV.npTessellationState(this.address(), value);
            return this;
        }
    }
}

