/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGraphicsShaderGroupCreateInfoNV;

public class VkGraphicsPipelineShaderGroupsCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int GROUPCOUNT;
    public static final int PGROUPS;
    public static final int PIPELINECOUNT;
    public static final int PPIPELINES;

    public VkGraphicsPipelineShaderGroupsCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkGraphicsPipelineShaderGroupsCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int groupCount() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(this.address());
    }

    @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *")
    public VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address());
    }

    @NativeType(value="uint32_t")
    public int pipelineCount() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPipeline const *")
    public LongBuffer pPipelines() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address());
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV sType$Default() {
        return this.sType(1000277002);
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pGroups(@NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *") VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pPipelines(@Nullable @NativeType(value="VkPipeline const *") LongBuffer value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV set(int sType, long pNext, VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups, @Nullable LongBuffer pPipelines) {
        this.sType(sType);
        this.pNext(pNext);
        this.pGroups(pGroups);
        this.pPipelines(pPipelines);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV set(VkGraphicsPipelineShaderGroupsCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV malloc() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV calloc() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV create(long address) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, address);
    }

    @Nullable
    public static VkGraphicsPipelineShaderGroupsCreateInfoNV createSafe(long address) {
        return address == 0L ? null : VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkGraphicsPipelineShaderGroupsCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGraphicsPipelineShaderGroupsCreateInfoNV.__create(capacity, SIZEOF);
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, address, capacity);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV malloc(MemoryStack stack) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV calloc(MemoryStack stack) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(VkGraphicsPipelineShaderGroupsCreateInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ngroupCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GROUPCOUNT);
    }

    public static VkGraphicsShaderGroupCreateInfoNV.Buffer npGroups(long struct) {
        return VkGraphicsShaderGroupCreateInfoNV.create(MemoryUtil.memGetAddress(struct + (long)PGROUPS), VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct));
    }

    public static int npipelineCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINECOUNT);
    }

    @Nullable
    public static LongBuffer npPipelines(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPIPELINES), VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ngroupCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GROUPCOUNT, value);
    }

    public static void npGroups(long struct, VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PGROUPS, value.address());
        VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct, value.remaining());
    }

    public static void npipelineCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINECOUNT, value);
    }

    public static void npPipelines(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPIPELINES, MemoryUtil.memAddressSafe(value));
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int groupCount = VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct);
        long pGroups = MemoryUtil.memGetAddress(struct + (long)PGROUPS);
        Checks.check(pGroups);
        VkGraphicsPipelineShaderGroupsCreateInfoNV.validate(pGroups, groupCount, VkGraphicsShaderGroupCreateInfoNV.SIZEOF, VkGraphicsShaderGroupCreateInfoNV::validate);
        if (VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPIPELINES));
        }
    }

    static {
        Struct.Layout layout = VkGraphicsPipelineShaderGroupsCreateInfoNV.__struct(VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(POINTER_SIZE), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(POINTER_SIZE), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        GROUPCOUNT = layout.offsetof(2);
        PGROUPS = layout.offsetof(3);
        PIPELINECOUNT = layout.offsetof(4);
        PPIPELINES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkGraphicsPipelineShaderGroupsCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkGraphicsPipelineShaderGroupsCreateInfoNV ELEMENT_FACTORY = VkGraphicsPipelineShaderGroupsCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkGraphicsPipelineShaderGroupsCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int groupCount() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(this.address());
        }

        @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *")
        public VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address());
        }

        @NativeType(value="uint32_t")
        public int pipelineCount() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPipeline const *")
        public LongBuffer pPipelines() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pGroups(@NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *") VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address(), value);
            return this;
        }

        public Buffer pPipelines(@Nullable @NativeType(value="VkPipeline const *") LongBuffer value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address(), value);
            return this;
        }
    }
}

