/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageFormatProperties;

public class VkExternalImageFormatPropertiesNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGEFORMATPROPERTIES;
    public static final int EXTERNALMEMORYFEATURES;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;

    public VkExternalImageFormatPropertiesNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExternalImageFormatPropertiesNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageFormatProperties imageFormatProperties() {
        return VkExternalImageFormatPropertiesNV.nimageFormatProperties(this.address());
    }

    @NativeType(value="VkExternalMemoryFeatureFlagsNV")
    public int externalMemoryFeatures() {
        return VkExternalImageFormatPropertiesNV.nexternalMemoryFeatures(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int exportFromImportedHandleTypes() {
        return VkExternalImageFormatPropertiesNV.nexportFromImportedHandleTypes(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int compatibleHandleTypes() {
        return VkExternalImageFormatPropertiesNV.ncompatibleHandleTypes(this.address());
    }

    public static VkExternalImageFormatPropertiesNV malloc() {
        return VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV calloc() {
        return VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExternalImageFormatPropertiesNV create(long address) {
        return VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, address);
    }

    @Nullable
    public static VkExternalImageFormatPropertiesNV createSafe(long address) {
        return address == 0L ? null : VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalImageFormatPropertiesNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExternalImageFormatPropertiesNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalImageFormatPropertiesNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalImageFormatPropertiesNV.__create(capacity, SIZEOF);
        return VkExternalImageFormatPropertiesNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExternalImageFormatPropertiesNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalImageFormatPropertiesNV.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV mallocStack() {
        return VkExternalImageFormatPropertiesNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV callocStack() {
        return VkExternalImageFormatPropertiesNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV mallocStack(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.malloc(stack);
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV callocStack(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalImageFormatPropertiesNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalImageFormatPropertiesNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.calloc(capacity, stack);
    }

    public static VkExternalImageFormatPropertiesNV malloc(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalImageFormatPropertiesNV calloc(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.wrap(VkExternalImageFormatPropertiesNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageFormatProperties nimageFormatProperties(long struct) {
        return VkImageFormatProperties.create(struct + (long)IMAGEFORMATPROPERTIES);
    }

    public static int nexternalMemoryFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXTERNALMEMORYFEATURES);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPATIBLEHANDLETYPES);
    }

    static {
        Struct.Layout layout = VkExternalImageFormatPropertiesNV.__struct(VkExternalImageFormatPropertiesNV.__member(VkImageFormatProperties.SIZEOF, VkImageFormatProperties.ALIGNOF), VkExternalImageFormatPropertiesNV.__member(4), VkExternalImageFormatPropertiesNV.__member(4), VkExternalImageFormatPropertiesNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGEFORMATPROPERTIES = layout.offsetof(0);
        EXTERNALMEMORYFEATURES = layout.offsetof(1);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(2);
        COMPATIBLEHANDLETYPES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkExternalImageFormatPropertiesNV, Buffer>
    implements NativeResource {
        private static final VkExternalImageFormatPropertiesNV ELEMENT_FACTORY = VkExternalImageFormatPropertiesNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalImageFormatPropertiesNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageFormatProperties imageFormatProperties() {
            return VkExternalImageFormatPropertiesNV.nimageFormatProperties(this.address());
        }

        @NativeType(value="VkExternalMemoryFeatureFlagsNV")
        public int externalMemoryFeatures() {
            return VkExternalImageFormatPropertiesNV.nexternalMemoryFeatures(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int exportFromImportedHandleTypes() {
            return VkExternalImageFormatPropertiesNV.nexportFromImportedHandleTypes(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int compatibleHandleTypes() {
            return VkExternalImageFormatPropertiesNV.ncompatibleHandleTypes(this.address());
        }
    }
}

