/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    public VkExtent2D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExtent2D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkExtent2D.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkExtent2D.nheight(this.address());
    }

    public VkExtent2D width(@NativeType(value="uint32_t") int value) {
        VkExtent2D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent2D height(@NativeType(value="uint32_t") int value) {
        VkExtent2D.nheight(this.address(), value);
        return this;
    }

    public VkExtent2D set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public VkExtent2D set(VkExtent2D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExtent2D malloc() {
        return VkExtent2D.wrap(VkExtent2D.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExtent2D calloc() {
        return VkExtent2D.wrap(VkExtent2D.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExtent2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExtent2D.wrap(VkExtent2D.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExtent2D create(long address) {
        return VkExtent2D.wrap(VkExtent2D.class, address);
    }

    @Nullable
    public static VkExtent2D createSafe(long address) {
        return address == 0L ? null : VkExtent2D.wrap(VkExtent2D.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExtent2D.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExtent2D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExtent2D.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtent2D.__create(capacity, SIZEOF);
        return VkExtent2D.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExtent2D.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExtent2D.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExtent2D mallocStack() {
        return VkExtent2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent2D callocStack() {
        return VkExtent2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent2D mallocStack(MemoryStack stack) {
        return VkExtent2D.malloc(stack);
    }

    @Deprecated
    public static VkExtent2D callocStack(MemoryStack stack) {
        return VkExtent2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExtent2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExtent2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtent2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtent2D.calloc(capacity, stack);
    }

    public static VkExtent2D malloc(MemoryStack stack) {
        return VkExtent2D.wrap(VkExtent2D.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtent2D calloc(MemoryStack stack) {
        return VkExtent2D.wrap(VkExtent2D.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExtent2D.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExtent2D.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = VkExtent2D.__struct(VkExtent2D.__member(4), VkExtent2D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkExtent2D, Buffer>
    implements NativeResource {
        private static final VkExtent2D ELEMENT_FACTORY = VkExtent2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExtent2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkExtent2D.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkExtent2D.nheight(this.address());
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkExtent2D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkExtent2D.nheight(this.address(), value);
            return this;
        }
    }
}

