/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceOrHostAddressKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int HOSTADDRESS;

    public VkDeviceOrHostAddressKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceOrHostAddressKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkDeviceOrHostAddressKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="void *")
    public long hostAddress() {
        return VkDeviceOrHostAddressKHR.nhostAddress(this.address());
    }

    public VkDeviceOrHostAddressKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceOrHostAddressKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressKHR hostAddress(@NativeType(value="void *") long value) {
        VkDeviceOrHostAddressKHR.nhostAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressKHR set(VkDeviceOrHostAddressKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceOrHostAddressKHR malloc() {
        return VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceOrHostAddressKHR calloc() {
        return VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceOrHostAddressKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceOrHostAddressKHR create(long address) {
        return VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, address);
    }

    @Nullable
    public static VkDeviceOrHostAddressKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceOrHostAddressKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDeviceOrHostAddressKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceOrHostAddressKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceOrHostAddressKHR.__create(capacity, SIZEOF);
        return VkDeviceOrHostAddressKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDeviceOrHostAddressKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceOrHostAddressKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkDeviceOrHostAddressKHR malloc(MemoryStack stack) {
        return VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceOrHostAddressKHR calloc(MemoryStack stack) {
        return VkDeviceOrHostAddressKHR.wrap(VkDeviceOrHostAddressKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDeviceOrHostAddressKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDeviceOrHostAddressKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static long nhostAddress(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HOSTADDRESS);
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    public static void nhostAddress(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HOSTADDRESS, value);
    }

    static {
        Struct.Layout layout = VkDeviceOrHostAddressKHR.__union(VkDeviceOrHostAddressKHR.__member(8), VkDeviceOrHostAddressKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        HOSTADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceOrHostAddressKHR, Buffer>
    implements NativeResource {
        private static final VkDeviceOrHostAddressKHR ELEMENT_FACTORY = VkDeviceOrHostAddressKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceOrHostAddressKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkDeviceOrHostAddressKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="void *")
        public long hostAddress() {
            return VkDeviceOrHostAddressKHR.nhostAddress(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceOrHostAddressKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer hostAddress(@NativeType(value="void *") long value) {
            VkDeviceOrHostAddressKHR.nhostAddress(this.address(), value);
            return this;
        }
    }
}

