/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferCreateInfo;
import org.lwjgl.vulkan.VkDeviceBufferMemoryRequirements;

public class VkDeviceBufferMemoryRequirementsKHR
extends VkDeviceBufferMemoryRequirements {
    public VkDeviceBufferMemoryRequirementsKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceBufferMemoryRequirementsKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR sType$Default() {
        return this.sType(1000413002);
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceBufferMemoryRequirementsKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR pCreateInfo(@NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo value) {
        VkDeviceBufferMemoryRequirementsKHR.npCreateInfo(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR set(int sType, long pNext, VkBufferCreateInfo pCreateInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        return this;
    }

    public VkDeviceBufferMemoryRequirementsKHR set(VkDeviceBufferMemoryRequirementsKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceBufferMemoryRequirementsKHR malloc() {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceBufferMemoryRequirementsKHR calloc() {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceBufferMemoryRequirementsKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceBufferMemoryRequirementsKHR create(long address) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, address);
    }

    @Nullable
    public static VkDeviceBufferMemoryRequirementsKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDeviceBufferMemoryRequirementsKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceBufferMemoryRequirementsKHR.__create(capacity, SIZEOF);
        return VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkDeviceBufferMemoryRequirementsKHR malloc(MemoryStack stack) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceBufferMemoryRequirementsKHR calloc(MemoryStack stack) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(VkDeviceBufferMemoryRequirementsKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDeviceBufferMemoryRequirementsKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDeviceBufferMemoryRequirements.Buffer {
        private static final VkDeviceBufferMemoryRequirementsKHR ELEMENT_FACTORY = VkDeviceBufferMemoryRequirementsKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceBufferMemoryRequirementsKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceBufferMemoryRequirementsKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000413002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceBufferMemoryRequirementsKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pCreateInfo(@NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo value) {
            VkDeviceBufferMemoryRequirementsKHR.npCreateInfo(this.address(), value);
            return this;
        }
    }
}

