/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorUpdateTemplateEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;
    public static final int DESCRIPTORTYPE;
    public static final int OFFSET;
    public static final int STRIDE;

    public VkDescriptorUpdateTemplateEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorUpdateTemplateEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int dstBinding() {
        return VkDescriptorUpdateTemplateEntry.ndstBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstArrayElement() {
        return VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address());
    }

    @NativeType(value="size_t")
    public long offset() {
        return VkDescriptorUpdateTemplateEntry.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long stride() {
        return VkDescriptorUpdateTemplateEntry.nstride(this.address());
    }

    public VkDescriptorUpdateTemplateEntry dstBinding(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateEntry.ndstBinding(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry dstArrayElement(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry descriptorCount(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry offset(@NativeType(value="size_t") long value) {
        VkDescriptorUpdateTemplateEntry.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry stride(@NativeType(value="size_t") long value) {
        VkDescriptorUpdateTemplateEntry.nstride(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry set(int dstBinding, int dstArrayElement, int descriptorCount, int descriptorType, long offset, long stride) {
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        this.descriptorType(descriptorType);
        this.offset(offset);
        this.stride(stride);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry set(VkDescriptorUpdateTemplateEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorUpdateTemplateEntry malloc() {
        return VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntry calloc() {
        return VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorUpdateTemplateEntry create(long address) {
        return VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, address);
    }

    @Nullable
    public static VkDescriptorUpdateTemplateEntry createSafe(long address) {
        return address == 0L ? null : VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDescriptorUpdateTemplateEntry.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorUpdateTemplateEntry.__create(capacity, SIZEOF);
        return VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry mallocStack() {
        return VkDescriptorUpdateTemplateEntry.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry callocStack() {
        return VkDescriptorUpdateTemplateEntry.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry mallocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry callocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorUpdateTemplateEntry.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorUpdateTemplateEntry.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.calloc(capacity, stack);
    }

    public static VkDescriptorUpdateTemplateEntry malloc(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorUpdateTemplateEntry calloc(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.wrap(VkDescriptorUpdateTemplateEntry.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndstBinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTBINDING);
    }

    public static int ndstArrayElement(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTARRAYELEMENT);
    }

    public static int ndescriptorCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORCOUNT);
    }

    public static int ndescriptorType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORTYPE);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    public static long nstride(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)STRIDE);
    }

    public static void ndstBinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTBINDING, value);
    }

    public static void ndstArrayElement(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTARRAYELEMENT, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void ndescriptorType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORTYPE, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OFFSET, value);
    }

    public static void nstride(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorUpdateTemplateEntry.__struct(VkDescriptorUpdateTemplateEntry.__member(4), VkDescriptorUpdateTemplateEntry.__member(4), VkDescriptorUpdateTemplateEntry.__member(4), VkDescriptorUpdateTemplateEntry.__member(4), VkDescriptorUpdateTemplateEntry.__member(POINTER_SIZE), VkDescriptorUpdateTemplateEntry.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DSTBINDING = layout.offsetof(0);
        DSTARRAYELEMENT = layout.offsetof(1);
        DESCRIPTORCOUNT = layout.offsetof(2);
        DESCRIPTORTYPE = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        STRIDE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorUpdateTemplateEntry, Buffer>
    implements NativeResource {
        private static final VkDescriptorUpdateTemplateEntry ELEMENT_FACTORY = VkDescriptorUpdateTemplateEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDescriptorUpdateTemplateEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int dstBinding() {
            return VkDescriptorUpdateTemplateEntry.ndstBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstArrayElement() {
            return VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address());
        }

        @NativeType(value="size_t")
        public long offset() {
            return VkDescriptorUpdateTemplateEntry.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long stride() {
            return VkDescriptorUpdateTemplateEntry.nstride(this.address());
        }

        public Buffer dstBinding(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateEntry.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="size_t") long value) {
            VkDescriptorUpdateTemplateEntry.noffset(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="size_t") long value) {
            VkDescriptorUpdateTemplateEntry.nstride(this.address(), value);
            return this;
        }
    }
}

