/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferMemoryBarrier2;
import org.lwjgl.vulkan.VkDependencyInfo;
import org.lwjgl.vulkan.VkImageMemoryBarrier2;
import org.lwjgl.vulkan.VkMemoryBarrier2;

public class VkDependencyInfoKHR
extends VkDependencyInfo {
    public VkDependencyInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDependencyInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDependencyInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR sType$Default() {
        return this.sType(1000314003);
    }

    @Override
    public VkDependencyInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDependencyInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
        VkDependencyInfoKHR.ndependencyFlags(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR pMemoryBarriers(@Nullable @NativeType(value="VkMemoryBarrier2 const *") VkMemoryBarrier2.Buffer value) {
        VkDependencyInfoKHR.npMemoryBarriers(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR pBufferMemoryBarriers(@Nullable @NativeType(value="VkBufferMemoryBarrier2 const *") VkBufferMemoryBarrier2.Buffer value) {
        VkDependencyInfoKHR.npBufferMemoryBarriers(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR pImageMemoryBarriers(@Nullable @NativeType(value="VkImageMemoryBarrier2 const *") VkImageMemoryBarrier2.Buffer value) {
        VkDependencyInfoKHR.npImageMemoryBarriers(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR set(int sType, long pNext, int dependencyFlags, @Nullable VkMemoryBarrier2.Buffer pMemoryBarriers, @Nullable VkBufferMemoryBarrier2.Buffer pBufferMemoryBarriers, @Nullable VkImageMemoryBarrier2.Buffer pImageMemoryBarriers) {
        this.sType(sType);
        this.pNext(pNext);
        this.dependencyFlags(dependencyFlags);
        this.pMemoryBarriers(pMemoryBarriers);
        this.pBufferMemoryBarriers(pBufferMemoryBarriers);
        this.pImageMemoryBarriers(pImageMemoryBarriers);
        return this;
    }

    public VkDependencyInfoKHR set(VkDependencyInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDependencyInfoKHR malloc() {
        return VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDependencyInfoKHR calloc() {
        return VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDependencyInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDependencyInfoKHR create(long address) {
        return VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, address);
    }

    @Nullable
    public static VkDependencyInfoKHR createSafe(long address) {
        return address == 0L ? null : VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDependencyInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDependencyInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDependencyInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDependencyInfoKHR.__create(capacity, SIZEOF);
        return VkDependencyInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDependencyInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDependencyInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkDependencyInfoKHR malloc(MemoryStack stack) {
        return VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDependencyInfoKHR calloc(MemoryStack stack) {
        return VkDependencyInfoKHR.wrap(VkDependencyInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDependencyInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDependencyInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDependencyInfo.Buffer {
        private static final VkDependencyInfoKHR ELEMENT_FACTORY = VkDependencyInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDependencyInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDependencyInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000314003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDependencyInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
            VkDependencyInfoKHR.ndependencyFlags(this.address(), value);
            return this;
        }

        @Override
        public Buffer pMemoryBarriers(@Nullable @NativeType(value="VkMemoryBarrier2 const *") VkMemoryBarrier2.Buffer value) {
            VkDependencyInfoKHR.npMemoryBarriers(this.address(), value);
            return this;
        }

        @Override
        public Buffer pBufferMemoryBarriers(@Nullable @NativeType(value="VkBufferMemoryBarrier2 const *") VkBufferMemoryBarrier2.Buffer value) {
            VkDependencyInfoKHR.npBufferMemoryBarriers(this.address(), value);
            return this;
        }

        @Override
        public Buffer pImageMemoryBarriers(@Nullable @NativeType(value="VkImageMemoryBarrier2 const *") VkImageMemoryBarrier2.Buffer value) {
            VkDependencyInfoKHR.npImageMemoryBarriers(this.address(), value);
            return this;
        }
    }
}

