/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCoarseSampleLocationNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXELX;
    public static final int PIXELY;
    public static final int SAMPLE;

    public VkCoarseSampleLocationNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCoarseSampleLocationNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int pixelX() {
        return VkCoarseSampleLocationNV.npixelX(this.address());
    }

    @NativeType(value="uint32_t")
    public int pixelY() {
        return VkCoarseSampleLocationNV.npixelY(this.address());
    }

    @NativeType(value="uint32_t")
    public int sample() {
        return VkCoarseSampleLocationNV.nsample(this.address());
    }

    public VkCoarseSampleLocationNV pixelX(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleLocationNV.npixelX(this.address(), value);
        return this;
    }

    public VkCoarseSampleLocationNV pixelY(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleLocationNV.npixelY(this.address(), value);
        return this;
    }

    public VkCoarseSampleLocationNV sample(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleLocationNV.nsample(this.address(), value);
        return this;
    }

    public VkCoarseSampleLocationNV set(int pixelX, int pixelY, int sample) {
        this.pixelX(pixelX);
        this.pixelY(pixelY);
        this.sample(sample);
        return this;
    }

    public VkCoarseSampleLocationNV set(VkCoarseSampleLocationNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCoarseSampleLocationNV malloc() {
        return VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkCoarseSampleLocationNV calloc() {
        return VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkCoarseSampleLocationNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkCoarseSampleLocationNV create(long address) {
        return VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, address);
    }

    @Nullable
    public static VkCoarseSampleLocationNV createSafe(long address) {
        return address == 0L ? null : VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkCoarseSampleLocationNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkCoarseSampleLocationNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCoarseSampleLocationNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCoarseSampleLocationNV.__create(capacity, SIZEOF);
        return VkCoarseSampleLocationNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkCoarseSampleLocationNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkCoarseSampleLocationNV.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkCoarseSampleLocationNV mallocStack() {
        return VkCoarseSampleLocationNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCoarseSampleLocationNV callocStack() {
        return VkCoarseSampleLocationNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCoarseSampleLocationNV mallocStack(MemoryStack stack) {
        return VkCoarseSampleLocationNV.malloc(stack);
    }

    @Deprecated
    public static VkCoarseSampleLocationNV callocStack(MemoryStack stack) {
        return VkCoarseSampleLocationNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCoarseSampleLocationNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCoarseSampleLocationNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCoarseSampleLocationNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCoarseSampleLocationNV.calloc(capacity, stack);
    }

    public static VkCoarseSampleLocationNV malloc(MemoryStack stack) {
        return VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCoarseSampleLocationNV calloc(MemoryStack stack) {
        return VkCoarseSampleLocationNV.wrap(VkCoarseSampleLocationNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkCoarseSampleLocationNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkCoarseSampleLocationNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npixelX(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXELX);
    }

    public static int npixelY(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXELY);
    }

    public static int nsample(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLE);
    }

    public static void npixelX(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIXELX, value);
    }

    public static void npixelY(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIXELY, value);
    }

    public static void nsample(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLE, value);
    }

    static {
        Struct.Layout layout = VkCoarseSampleLocationNV.__struct(VkCoarseSampleLocationNV.__member(4), VkCoarseSampleLocationNV.__member(4), VkCoarseSampleLocationNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXELX = layout.offsetof(0);
        PIXELY = layout.offsetof(1);
        SAMPLE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkCoarseSampleLocationNV, Buffer>
    implements NativeResource {
        private static final VkCoarseSampleLocationNV ELEMENT_FACTORY = VkCoarseSampleLocationNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCoarseSampleLocationNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int pixelX() {
            return VkCoarseSampleLocationNV.npixelX(this.address());
        }

        @NativeType(value="uint32_t")
        public int pixelY() {
            return VkCoarseSampleLocationNV.npixelY(this.address());
        }

        @NativeType(value="uint32_t")
        public int sample() {
            return VkCoarseSampleLocationNV.nsample(this.address());
        }

        public Buffer pixelX(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleLocationNV.npixelX(this.address(), value);
            return this;
        }

        public Buffer pixelY(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleLocationNV.npixelY(this.address(), value);
            return this;
        }

        public Buffer sample(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleLocationNV.nsample(this.address(), value);
            return this;
        }
    }
}

