/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferMemoryRequirementsInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;

    public VkBufferMemoryRequirementsInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferMemoryRequirementsInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferMemoryRequirementsInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferMemoryRequirementsInfo2.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferMemoryRequirementsInfo2.nbuffer(this.address());
    }

    public VkBufferMemoryRequirementsInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkBufferMemoryRequirementsInfo2.nsType(this.address(), value);
        return this;
    }

    public VkBufferMemoryRequirementsInfo2 sType$Default() {
        return this.sType(1000146000);
    }

    public VkBufferMemoryRequirementsInfo2 pNext(@NativeType(value="void const *") long value) {
        VkBufferMemoryRequirementsInfo2.npNext(this.address(), value);
        return this;
    }

    public VkBufferMemoryRequirementsInfo2 buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferMemoryRequirementsInfo2.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferMemoryRequirementsInfo2 set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferMemoryRequirementsInfo2 set(VkBufferMemoryRequirementsInfo2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferMemoryRequirementsInfo2 malloc() {
        return VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2 calloc() {
        return VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferMemoryRequirementsInfo2 create(long address) {
        return VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, address);
    }

    @Nullable
    public static VkBufferMemoryRequirementsInfo2 createSafe(long address) {
        return address == 0L ? null : VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferMemoryRequirementsInfo2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferMemoryRequirementsInfo2.__create(capacity, SIZEOF);
        return VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2 mallocStack() {
        return VkBufferMemoryRequirementsInfo2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2 callocStack() {
        return VkBufferMemoryRequirementsInfo2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2 mallocStack(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.malloc(stack);
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2 callocStack(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferMemoryRequirementsInfo2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferMemoryRequirementsInfo2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.calloc(capacity, stack);
    }

    public static VkBufferMemoryRequirementsInfo2 malloc(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2 calloc(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.wrap(VkBufferMemoryRequirementsInfo2.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = VkBufferMemoryRequirementsInfo2.__struct(VkBufferMemoryRequirementsInfo2.__member(4), VkBufferMemoryRequirementsInfo2.__member(POINTER_SIZE), VkBufferMemoryRequirementsInfo2.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferMemoryRequirementsInfo2, Buffer>
    implements NativeResource {
        private static final VkBufferMemoryRequirementsInfo2 ELEMENT_FACTORY = VkBufferMemoryRequirementsInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferMemoryRequirementsInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferMemoryRequirementsInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferMemoryRequirementsInfo2.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferMemoryRequirementsInfo2.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferMemoryRequirementsInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000146000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferMemoryRequirementsInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferMemoryRequirementsInfo2.nbuffer(this.address(), value);
            return this;
        }
    }
}

