/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBufferDeviceAddressCreateInfoEXT;
import org.lwjgl.vulkan.VkBufferOpaqueCaptureAddressCreateInfo;
import org.lwjgl.vulkan.VkBufferOpaqueCaptureAddressCreateInfoKHR;
import org.lwjgl.vulkan.VkDedicatedAllocationBufferCreateInfoNV;
import org.lwjgl.vulkan.VkExternalMemoryBufferCreateInfo;
import org.lwjgl.vulkan.VkExternalMemoryBufferCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoDecodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoProfileKHR;
import org.lwjgl.vulkan.VkVideoProfilesKHR;

public class VkBufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SIZE;
    public static final int USAGE;
    public static final int SHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;

    public VkBufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkBufferCreateFlags")
    public int flags() {
        return VkBufferCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferCreateInfo.nsize(this.address());
    }

    @NativeType(value="VkBufferUsageFlags")
    public int usage() {
        return VkBufferCreateInfo.nusage(this.address());
    }

    @NativeType(value="VkSharingMode")
    public int sharingMode() {
        return VkBufferCreateInfo.nsharingMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndexCount() {
        return VkBufferCreateInfo.nqueueFamilyIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pQueueFamilyIndices() {
        return VkBufferCreateInfo.npQueueFamilyIndices(this.address());
    }

    public VkBufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo sType$Default() {
        return this.sType(12);
    }

    public VkBufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo pNext(VkBufferDeviceAddressCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkBufferOpaqueCaptureAddressCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkBufferOpaqueCaptureAddressCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkDedicatedAllocationBufferCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkExternalMemoryBufferCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkExternalMemoryBufferCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkVideoDecodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkVideoDecodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkVideoEncodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkVideoEncodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkVideoProfileKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo pNext(VkVideoProfilesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferCreateInfo flags(@NativeType(value="VkBufferCreateFlags") int value) {
        VkBufferCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo usage(@NativeType(value="VkBufferUsageFlags") int value) {
        VkBufferCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo sharingMode(@NativeType(value="VkSharingMode") int value) {
        VkBufferCreateInfo.nsharingMode(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo queueFamilyIndexCount(@NativeType(value="uint32_t") int value) {
        VkBufferCreateInfo.nqueueFamilyIndexCount(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBufferCreateInfo.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo set(int sType, long pNext, int flags, long size, int usage, int sharingMode, int queueFamilyIndexCount, @Nullable IntBuffer pQueueFamilyIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.size(size);
        this.usage(usage);
        this.sharingMode(sharingMode);
        this.queueFamilyIndexCount(queueFamilyIndexCount);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        return this;
    }

    public VkBufferCreateInfo set(VkBufferCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferCreateInfo malloc() {
        return VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferCreateInfo calloc() {
        return VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferCreateInfo create(long address) {
        return VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, address);
    }

    @Nullable
    public static VkBufferCreateInfo createSafe(long address) {
        return address == 0L ? null : VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCreateInfo.__create(capacity, SIZEOF);
        return VkBufferCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBufferCreateInfo mallocStack() {
        return VkBufferCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferCreateInfo callocStack() {
        return VkBufferCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferCreateInfo mallocStack(MemoryStack stack) {
        return VkBufferCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkBufferCreateInfo callocStack(MemoryStack stack) {
        return VkBufferCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferCreateInfo.calloc(capacity, stack);
    }

    public static VkBufferCreateInfo malloc(MemoryStack stack) {
        return VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferCreateInfo calloc(MemoryStack stack) {
        return VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nsharingMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES), VkBufferCreateInfo.nqueueFamilyIndexCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nsharingMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEFAMILYINDICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkBufferCreateInfo.nqueueFamilyIndexCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkBufferCreateInfo.__struct(VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(POINTER_SIZE), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(8), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(4), VkBufferCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SIZE = layout.offsetof(3);
        USAGE = layout.offsetof(4);
        SHARINGMODE = layout.offsetof(5);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(6);
        PQUEUEFAMILYINDICES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkBufferCreateInfo ELEMENT_FACTORY = VkBufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkBufferCreateFlags")
        public int flags() {
            return VkBufferCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferCreateInfo.nsize(this.address());
        }

        @NativeType(value="VkBufferUsageFlags")
        public int usage() {
            return VkBufferCreateInfo.nusage(this.address());
        }

        @NativeType(value="VkSharingMode")
        public int sharingMode() {
            return VkBufferCreateInfo.nsharingMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndexCount() {
            return VkBufferCreateInfo.nqueueFamilyIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pQueueFamilyIndices() {
            return VkBufferCreateInfo.npQueueFamilyIndices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(12);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkBufferDeviceAddressCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBufferOpaqueCaptureAddressCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBufferOpaqueCaptureAddressCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDedicatedAllocationBufferCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExternalMemoryBufferCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExternalMemoryBufferCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoProfileKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoProfilesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkBufferCreateFlags") int value) {
            VkBufferCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkBufferUsageFlags") int value) {
            VkBufferCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer sharingMode(@NativeType(value="VkSharingMode") int value) {
            VkBufferCreateInfo.nsharingMode(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndexCount(@NativeType(value="uint32_t") int value) {
            VkBufferCreateInfo.nqueueFamilyIndexCount(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBufferCreateInfo.npQueueFamilyIndices(this.address(), value);
            return this;
        }
    }
}

