/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindVertexBufferIndirectCommandNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERADDRESS;
    public static final int SIZE;
    public static final int STRIDE;

    public VkBindVertexBufferIndirectCommandNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindVertexBufferIndirectCommandNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long bufferAddress() {
        return VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkBindVertexBufferIndirectCommandNV.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int stride() {
        return VkBindVertexBufferIndirectCommandNV.nstride(this.address());
    }

    public VkBindVertexBufferIndirectCommandNV bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV size(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandNV.nsize(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV stride(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandNV.nstride(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV set(long bufferAddress, int size, int stride) {
        this.bufferAddress(bufferAddress);
        this.size(size);
        this.stride(stride);
        return this;
    }

    public VkBindVertexBufferIndirectCommandNV set(VkBindVertexBufferIndirectCommandNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindVertexBufferIndirectCommandNV malloc() {
        return VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindVertexBufferIndirectCommandNV calloc() {
        return VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindVertexBufferIndirectCommandNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBindVertexBufferIndirectCommandNV create(long address) {
        return VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, address);
    }

    @Nullable
    public static VkBindVertexBufferIndirectCommandNV createSafe(long address) {
        return address == 0L ? null : VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBindVertexBufferIndirectCommandNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindVertexBufferIndirectCommandNV.__create(capacity, SIZEOF);
        return VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, address, capacity);
    }

    public static VkBindVertexBufferIndirectCommandNV malloc(MemoryStack stack) {
        return VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindVertexBufferIndirectCommandNV calloc(MemoryStack stack) {
        return VkBindVertexBufferIndirectCommandNV.wrap(VkBindVertexBufferIndirectCommandNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBindVertexBufferIndirectCommandNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFERADDRESS);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int nstride(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRIDE);
    }

    public static void nbufferAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFERADDRESS, value);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void nstride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkBindVertexBufferIndirectCommandNV.__struct(VkBindVertexBufferIndirectCommandNV.__member(8), VkBindVertexBufferIndirectCommandNV.__member(4), VkBindVertexBufferIndirectCommandNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERADDRESS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindVertexBufferIndirectCommandNV, Buffer>
    implements NativeResource {
        private static final VkBindVertexBufferIndirectCommandNV ELEMENT_FACTORY = VkBindVertexBufferIndirectCommandNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindVertexBufferIndirectCommandNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long bufferAddress() {
            return VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkBindVertexBufferIndirectCommandNV.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int stride() {
            return VkBindVertexBufferIndirectCommandNV.nstride(this.address());
        }

        public Buffer bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindVertexBufferIndirectCommandNV.nbufferAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandNV.nsize(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandNV.nstride(this.address(), value);
            return this;
        }
    }
}

