/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindImagePlaneMemoryInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PLANEASPECT;

    public VkBindImagePlaneMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindImagePlaneMemoryInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindImagePlaneMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindImagePlaneMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkImageAspectFlagBits")
    public int planeAspect() {
        return VkBindImagePlaneMemoryInfo.nplaneAspect(this.address());
    }

    public VkBindImagePlaneMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo sType$Default() {
        return this.sType(1000156002);
    }

    public VkBindImagePlaneMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfo.nplaneAspect(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfo set(VkBindImagePlaneMemoryInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfo malloc() {
        return VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo calloc() {
        return VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBindImagePlaneMemoryInfo create(long address) {
        return VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, address);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfo createSafe(long address) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImagePlaneMemoryInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBindImagePlaneMemoryInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImagePlaneMemoryInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImagePlaneMemoryInfo.__create(capacity, SIZEOF);
        return VkBindImagePlaneMemoryInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBindImagePlaneMemoryInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfo mallocStack() {
        return VkBindImagePlaneMemoryInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfo callocStack() {
        return VkBindImagePlaneMemoryInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfo mallocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.malloc(stack);
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfo callocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.calloc(capacity, stack);
    }

    public static VkBindImagePlaneMemoryInfo malloc(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo calloc(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nplaneAspect(long struct) {
        return UNSAFE.getInt(null, struct + (long)PLANEASPECT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nplaneAspect(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PLANEASPECT, value);
    }

    static {
        Struct.Layout layout = VkBindImagePlaneMemoryInfo.__struct(VkBindImagePlaneMemoryInfo.__member(4), VkBindImagePlaneMemoryInfo.__member(POINTER_SIZE), VkBindImagePlaneMemoryInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PLANEASPECT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindImagePlaneMemoryInfo, Buffer>
    implements NativeResource {
        private static final VkBindImagePlaneMemoryInfo ELEMENT_FACTORY = VkBindImagePlaneMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindImagePlaneMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindImagePlaneMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindImagePlaneMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkImageAspectFlagBits")
        public int planeAspect() {
            return VkBindImagePlaneMemoryInfo.nplaneAspect(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000156002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfo.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

