/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.VkAccelerationStructureCreateInfoNV;
import org.lwjgl.vulkan.VkAccelerationStructureInfoNV;
import org.lwjgl.vulkan.VkAccelerationStructureMemoryRequirementsInfoNV;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkBindAccelerationStructureMemoryInfoNV;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkMemoryRequirements2KHR;
import org.lwjgl.vulkan.VkRayTracingPipelineCreateInfoNV;

public class NVRayTracing {
    public static final int VK_NV_RAY_TRACING_SPEC_VERSION = 3;
    public static final String VK_NV_RAY_TRACING_EXTENSION_NAME = "VK_NV_ray_tracing";
    public static final int VK_SHADER_UNUSED_NV = -1;
    public static final int VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV = 1000165000;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV = 1000165001;
    public static final int VK_STRUCTURE_TYPE_GEOMETRY_NV = 1000165003;
    public static final int VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV = 1000165004;
    public static final int VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV = 1000165005;
    public static final int VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV = 1000165006;
    public static final int VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV = 1000165007;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV = 1000165008;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV = 1000165009;
    public static final int VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV = 1000165011;
    public static final int VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV = 1000165012;
    public static final int VK_SHADER_STAGE_RAYGEN_BIT_NV = 256;
    public static final int VK_SHADER_STAGE_ANY_HIT_BIT_NV = 512;
    public static final int VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV = 1024;
    public static final int VK_SHADER_STAGE_MISS_BIT_NV = 2048;
    public static final int VK_SHADER_STAGE_INTERSECTION_BIT_NV = 4096;
    public static final int VK_SHADER_STAGE_CALLABLE_BIT_NV = 8192;
    public static final int VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV = 0x200000;
    public static final int VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV = 0x2000000;
    public static final int VK_BUFFER_USAGE_RAY_TRACING_BIT_NV = 1024;
    public static final int VK_PIPELINE_BIND_POINT_RAY_TRACING_NV = 1000165000;
    public static final int VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV = 1000165000;
    public static final int VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV = 0x200000;
    public static final int VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV = 0x400000;
    public static final int VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV = 1000165000;
    public static final int VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV = 32;
    public static final int VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV = 1000165000;
    public static final int VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT = 1000165000;
    public static final int VK_INDEX_TYPE_NONE_NV = 1000165000;
    public static final int VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV = 0;
    public static final int VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV = 1;
    public static final int VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV = 2;
    public static final int VK_GEOMETRY_TYPE_TRIANGLES_NV = 0;
    public static final int VK_GEOMETRY_TYPE_AABBS_NV = 1;
    public static final int VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV = 0;
    public static final int VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV = 1;
    public static final int VK_GEOMETRY_OPAQUE_BIT_NV = 1;
    public static final int VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_NV = 2;
    public static final int VK_GEOMETRY_INSTANCE_TRIANGLE_CULL_DISABLE_BIT_NV = 1;
    public static final int VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_NV = 2;
    public static final int VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_NV = 4;
    public static final int VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_NV = 8;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_NV = 1;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_NV = 2;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV = 4;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV = 8;
    public static final int VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_NV = 16;
    public static final int VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_NV = 0;
    public static final int VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_NV = 1;
    public static final int VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV = 0;
    public static final int VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV = 1;
    public static final int VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV = 2;

    protected NVRayTracing() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateAccelerationStructureNV(VkDevice device, long pCreateInfo, long pAllocator, long pAccelerationStructure) {
        long __functionAddress = device.getCapabilities().vkCreateAccelerationStructureNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkAccelerationStructureCreateInfoNV.validate(pCreateInfo);
        }
        return JNI.callPPPPI(device.address(), pCreateInfo, pAllocator, pAccelerationStructure, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateAccelerationStructureNV(VkDevice device, @NativeType(value="VkAccelerationStructureCreateInfoNV const *") VkAccelerationStructureCreateInfoNV pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkAccelerationStructureNV *") LongBuffer pAccelerationStructure) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pAccelerationStructure, 1);
        }
        return NVRayTracing.nvkCreateAccelerationStructureNV(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pAccelerationStructure));
    }

    public static void nvkDestroyAccelerationStructureNV(VkDevice device, long accelerationStructure, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyAccelerationStructureNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJPV(device.address(), accelerationStructure, pAllocator, __functionAddress);
    }

    public static void vkDestroyAccelerationStructureNV(VkDevice device, @NativeType(value="VkAccelerationStructureNV") long accelerationStructure, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        NVRayTracing.nvkDestroyAccelerationStructureNV(device, accelerationStructure, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static void nvkGetAccelerationStructureMemoryRequirementsNV(VkDevice device, long pInfo, long pMemoryRequirements) {
        long __functionAddress = device.getCapabilities().vkGetAccelerationStructureMemoryRequirementsNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(device.address(), pInfo, pMemoryRequirements, __functionAddress);
    }

    public static void vkGetAccelerationStructureMemoryRequirementsNV(VkDevice device, @NativeType(value="VkAccelerationStructureMemoryRequirementsInfoNV const *") VkAccelerationStructureMemoryRequirementsInfoNV pInfo, @NativeType(value="VkMemoryRequirements2KHR *") VkMemoryRequirements2KHR pMemoryRequirements) {
        NVRayTracing.nvkGetAccelerationStructureMemoryRequirementsNV(device, pInfo.address(), pMemoryRequirements.address());
    }

    public static int nvkBindAccelerationStructureMemoryNV(VkDevice device, int bindInfoCount, long pBindInfos) {
        long __functionAddress = device.getCapabilities().vkBindAccelerationStructureMemoryNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Struct.validate(pBindInfos, bindInfoCount, VkBindAccelerationStructureMemoryInfoNV.SIZEOF, VkBindAccelerationStructureMemoryInfoNV::validate);
        }
        return JNI.callPPI(device.address(), bindInfoCount, pBindInfos, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkBindAccelerationStructureMemoryNV(VkDevice device, @NativeType(value="VkBindAccelerationStructureMemoryInfoNV const *") VkBindAccelerationStructureMemoryInfoNV.Buffer pBindInfos) {
        return NVRayTracing.nvkBindAccelerationStructureMemoryNV(device, pBindInfos.remaining(), pBindInfos.address());
    }

    public static void nvkCmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, long pInfo, long instanceData, long instanceOffset, int update, long dst, long src, long scratch, long scratchOffset) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBuildAccelerationStructureNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkAccelerationStructureInfoNV.validate(pInfo);
        }
        JNI.callPPJJJJJJV(commandBuffer.address(), pInfo, instanceData, instanceOffset, update, dst, src, scratch, scratchOffset, __functionAddress);
    }

    public static void vkCmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureInfoNV const *") VkAccelerationStructureInfoNV pInfo, @NativeType(value="VkBuffer") long instanceData, @NativeType(value="VkDeviceSize") long instanceOffset, @NativeType(value="VkBool32") boolean update, @NativeType(value="VkAccelerationStructureNV") long dst, @NativeType(value="VkAccelerationStructureNV") long src, @NativeType(value="VkBuffer") long scratch, @NativeType(value="VkDeviceSize") long scratchOffset) {
        NVRayTracing.nvkCmdBuildAccelerationStructureNV(commandBuffer, pInfo.address(), instanceData, instanceOffset, update ? 1 : 0, dst, src, scratch, scratchOffset);
    }

    public static void vkCmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureNV") long dst, @NativeType(value="VkAccelerationStructureNV") long src, @NativeType(value="VkCopyAccelerationStructureModeKHR") int mode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdCopyAccelerationStructureNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJV(commandBuffer.address(), dst, src, mode, __functionAddress);
    }

    public static void vkCmdTraceRaysNV(VkCommandBuffer commandBuffer, @NativeType(value="VkBuffer") long raygenShaderBindingTableBuffer, @NativeType(value="VkDeviceSize") long raygenShaderBindingOffset, @NativeType(value="VkBuffer") long missShaderBindingTableBuffer, @NativeType(value="VkDeviceSize") long missShaderBindingOffset, @NativeType(value="VkDeviceSize") long missShaderBindingStride, @NativeType(value="VkBuffer") long hitShaderBindingTableBuffer, @NativeType(value="VkDeviceSize") long hitShaderBindingOffset, @NativeType(value="VkDeviceSize") long hitShaderBindingStride, @NativeType(value="VkBuffer") long callableShaderBindingTableBuffer, @NativeType(value="VkDeviceSize") long callableShaderBindingOffset, @NativeType(value="VkDeviceSize") long callableShaderBindingStride, @NativeType(value="uint32_t") int width, @NativeType(value="uint32_t") int height, @NativeType(value="uint32_t") int depth) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdTraceRaysNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJJJJJJJJJJV(commandBuffer.address(), raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride, width, height, depth, __functionAddress);
    }

    public static int nvkCreateRayTracingPipelinesNV(VkDevice device, long pipelineCache, int createInfoCount, long pCreateInfos, long pAllocator, long pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateRayTracingPipelinesNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Struct.validate(pCreateInfos, createInfoCount, VkRayTracingPipelineCreateInfoNV.SIZEOF, VkRayTracingPipelineCreateInfoNV::validate);
        }
        return JNI.callPJPPPI(device.address(), pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateRayTracingPipelinesNV(VkDevice device, @NativeType(value="VkPipelineCache") long pipelineCache, @NativeType(value="VkRayTracingPipelineCreateInfoNV const *") VkRayTracingPipelineCreateInfoNV.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkPipeline *") LongBuffer pPipelines) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPipelines, pCreateInfos.remaining());
        }
        return NVRayTracing.nvkCreateRayTracingPipelinesNV(device, pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pPipelines));
    }

    public static int nvkGetRayTracingShaderGroupHandlesNV(VkDevice device, long pipeline, int firstGroup, int groupCount, long dataSize, long pData) {
        long __functionAddress = device.getCapabilities().vkGetRayTracingShaderGroupHandlesNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(device.address(), pipeline, firstGroup, groupCount, dataSize, pData, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetRayTracingShaderGroupHandlesNV(VkDevice device, @NativeType(value="VkPipeline") long pipeline, @NativeType(value="uint32_t") int firstGroup, @NativeType(value="uint32_t") int groupCount, @NativeType(value="void *") ByteBuffer pData) {
        return NVRayTracing.nvkGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, pData.remaining(), MemoryUtil.memAddress(pData));
    }

    public static int nvkGetAccelerationStructureHandleNV(VkDevice device, long accelerationStructure, long dataSize, long pData) {
        long __functionAddress = device.getCapabilities().vkGetAccelerationStructureHandleNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(device.address(), accelerationStructure, dataSize, pData, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetAccelerationStructureHandleNV(VkDevice device, @NativeType(value="VkAccelerationStructureNV") long accelerationStructure, @NativeType(value="void *") ByteBuffer pData) {
        return NVRayTracing.nvkGetAccelerationStructureHandleNV(device, accelerationStructure, pData.remaining(), MemoryUtil.memAddress(pData));
    }

    @NativeType(value="VkResult")
    public static int vkGetAccelerationStructureHandleNV(VkDevice device, @NativeType(value="VkAccelerationStructureNV") long accelerationStructure, @NativeType(value="void *") LongBuffer pData) {
        return NVRayTracing.nvkGetAccelerationStructureHandleNV(device, accelerationStructure, Integer.toUnsignedLong(pData.remaining()) << 3, MemoryUtil.memAddress(pData));
    }

    public static void nvkCmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, int accelerationStructureCount, long pAccelerationStructures, int queryType, long queryPool, int firstQuery) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdWriteAccelerationStructuresPropertiesNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPJV(commandBuffer.address(), accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, __functionAddress);
    }

    public static void vkCmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureNV const *") LongBuffer pAccelerationStructures, @NativeType(value="VkQueryType") int queryType, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int firstQuery) {
        NVRayTracing.nvkCmdWriteAccelerationStructuresPropertiesNV(commandBuffer, pAccelerationStructures.remaining(), MemoryUtil.memAddress(pAccelerationStructures), queryType, queryPool, firstQuery);
    }

    @NativeType(value="VkResult")
    public static int vkCompileDeferredNV(VkDevice device, @NativeType(value="VkPipeline") long pipeline, @NativeType(value="uint32_t") int shader) {
        long __functionAddress = device.getCapabilities().vkCompileDeferredNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJI(device.address(), pipeline, shader, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateAccelerationStructureNV(VkDevice device, @NativeType(value="VkAccelerationStructureCreateInfoNV const *") VkAccelerationStructureCreateInfoNV pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkAccelerationStructureNV *") long[] pAccelerationStructure) {
        long __functionAddress = device.getCapabilities().vkCreateAccelerationStructureNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pAccelerationStructure, 1);
            VkAccelerationStructureCreateInfoNV.validate(pCreateInfo.address());
        }
        return JNI.callPPPPI(device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pAccelerationStructure, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateRayTracingPipelinesNV(VkDevice device, @NativeType(value="VkPipelineCache") long pipelineCache, @NativeType(value="VkRayTracingPipelineCreateInfoNV const *") VkRayTracingPipelineCreateInfoNV.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkPipeline *") long[] pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateRayTracingPipelinesNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPipelines, pCreateInfos.remaining());
            Struct.validate(pCreateInfos.address(), pCreateInfos.remaining(), VkRayTracingPipelineCreateInfoNV.SIZEOF, VkRayTracingPipelineCreateInfoNV::validate);
        }
        return JNI.callPJPPPI(device.address(), pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe(pAllocator), pPipelines, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetAccelerationStructureHandleNV(VkDevice device, @NativeType(value="VkAccelerationStructureNV") long accelerationStructure, @NativeType(value="void *") long[] pData) {
        long __functionAddress = device.getCapabilities().vkGetAccelerationStructureHandleNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(device.address(), accelerationStructure, Integer.toUnsignedLong(pData.length) << 3, pData, __functionAddress);
    }

    public static void vkCmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, @NativeType(value="VkAccelerationStructureNV const *") long[] pAccelerationStructures, @NativeType(value="VkQueryType") int queryType, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int firstQuery) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdWriteAccelerationStructuresPropertiesNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPJV(commandBuffer.address(), pAccelerationStructures.length, pAccelerationStructures, queryType, queryPool, firstQuery, __functionAddress);
    }
}

