/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameHeader")
public class ZSTDFrameHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMECONTENTSIZE;
    public static final int WINDOWSIZE;
    public static final int BLOCKSIZEMAX;
    public static final int FRAMETYPE;
    public static final int HEADERSIZE;
    public static final int DICTID;
    public static final int CHECKSUMFLAG;

    public ZSTDFrameHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDFrameHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long frameContentSize() {
        return ZSTDFrameHeader.nframeContentSize(this.address());
    }

    @NativeType(value="unsigned long long")
    public long windowSize() {
        return ZSTDFrameHeader.nwindowSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockSizeMax() {
        return ZSTDFrameHeader.nblockSizeMax(this.address());
    }

    @NativeType(value="ZSTD_frameType_e")
    public int frameType() {
        return ZSTDFrameHeader.nframeType(this.address());
    }

    @NativeType(value="unsigned int")
    public int headerSize() {
        return ZSTDFrameHeader.nheaderSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int dictID() {
        return ZSTDFrameHeader.ndictID(this.address());
    }

    @NativeType(value="unsigned int")
    public int checksumFlag() {
        return ZSTDFrameHeader.nchecksumFlag(this.address());
    }

    public static ZSTDFrameHeader malloc() {
        return ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDFrameHeader calloc() {
        return ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDFrameHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, MemoryUtil.memAddress(container), container);
    }

    public static ZSTDFrameHeader create(long address) {
        return ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, address);
    }

    @Nullable
    public static ZSTDFrameHeader createSafe(long address) {
        return address == 0L ? null : ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDFrameHeader.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZSTDFrameHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDFrameHeader.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameHeader.__create(capacity, SIZEOF);
        return ZSTDFrameHeader.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZSTDFrameHeader.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDFrameHeader.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZSTDFrameHeader mallocStack() {
        return ZSTDFrameHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameHeader callocStack() {
        return ZSTDFrameHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameHeader mallocStack(MemoryStack stack) {
        return ZSTDFrameHeader.malloc(stack);
    }

    @Deprecated
    public static ZSTDFrameHeader callocStack(MemoryStack stack) {
        return ZSTDFrameHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDFrameHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameHeader.calloc(capacity, stack);
    }

    public static ZSTDFrameHeader malloc(MemoryStack stack) {
        return ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDFrameHeader calloc(MemoryStack stack) {
        return ZSTDFrameHeader.wrap(ZSTDFrameHeader.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZSTDFrameHeader.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZSTDFrameHeader.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nframeContentSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)FRAMECONTENTSIZE);
    }

    public static long nwindowSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)WINDOWSIZE);
    }

    public static int nblockSizeMax(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKSIZEMAX);
    }

    public static int nframeType(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMETYPE);
    }

    public static int nheaderSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEADERSIZE);
    }

    public static int ndictID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DICTID);
    }

    public static int nchecksumFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHECKSUMFLAG);
    }

    static {
        Struct.Layout layout = ZSTDFrameHeader.__struct(ZSTDFrameHeader.__member(8), ZSTDFrameHeader.__member(8), ZSTDFrameHeader.__member(4), ZSTDFrameHeader.__member(4), ZSTDFrameHeader.__member(4), ZSTDFrameHeader.__member(4), ZSTDFrameHeader.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMECONTENTSIZE = layout.offsetof(0);
        WINDOWSIZE = layout.offsetof(1);
        BLOCKSIZEMAX = layout.offsetof(2);
        FRAMETYPE = layout.offsetof(3);
        HEADERSIZE = layout.offsetof(4);
        DICTID = layout.offsetof(5);
        CHECKSUMFLAG = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameHeader, Buffer>
    implements NativeResource {
        private static final ZSTDFrameHeader ELEMENT_FACTORY = ZSTDFrameHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZSTDFrameHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long frameContentSize() {
            return ZSTDFrameHeader.nframeContentSize(this.address());
        }

        @NativeType(value="unsigned long long")
        public long windowSize() {
            return ZSTDFrameHeader.nwindowSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockSizeMax() {
            return ZSTDFrameHeader.nblockSizeMax(this.address());
        }

        @NativeType(value="ZSTD_frameType_e")
        public int frameType() {
            return ZSTDFrameHeader.nframeType(this.address());
        }

        @NativeType(value="unsigned int")
        public int headerSize() {
            return ZSTDFrameHeader.nheaderSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int dictID() {
            return ZSTDFrameHeader.ndictID(this.address());
        }

        @NativeType(value="unsigned int")
        public int checksumFlag() {
            return ZSTDFrameHeader.nchecksumFlag(this.address());
        }
    }
}

