/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZDICT_params_t")
public class ZDICTParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMPRESSIONLEVEL;
    public static final int NOTIFICATIONLEVEL;
    public static final int DICTID;

    public ZDICTParams(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZDICTParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int compressionLevel() {
        return ZDICTParams.ncompressionLevel(this.address());
    }

    @NativeType(value="unsigned")
    public int notificationLevel() {
        return ZDICTParams.nnotificationLevel(this.address());
    }

    @NativeType(value="unsigned")
    public int dictID() {
        return ZDICTParams.ndictID(this.address());
    }

    public ZDICTParams compressionLevel(int value) {
        ZDICTParams.ncompressionLevel(this.address(), value);
        return this;
    }

    public ZDICTParams notificationLevel(@NativeType(value="unsigned") int value) {
        ZDICTParams.nnotificationLevel(this.address(), value);
        return this;
    }

    public ZDICTParams dictID(@NativeType(value="unsigned") int value) {
        ZDICTParams.ndictID(this.address(), value);
        return this;
    }

    public ZDICTParams set(int compressionLevel, int notificationLevel, int dictID) {
        this.compressionLevel(compressionLevel);
        this.notificationLevel(notificationLevel);
        this.dictID(dictID);
        return this;
    }

    public ZDICTParams set(ZDICTParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZDICTParams malloc() {
        return ZDICTParams.wrap(ZDICTParams.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZDICTParams calloc() {
        return ZDICTParams.wrap(ZDICTParams.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZDICTParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZDICTParams.wrap(ZDICTParams.class, MemoryUtil.memAddress(container), container);
    }

    public static ZDICTParams create(long address) {
        return ZDICTParams.wrap(ZDICTParams.class, address);
    }

    @Nullable
    public static ZDICTParams createSafe(long address) {
        return address == 0L ? null : ZDICTParams.wrap(ZDICTParams.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZDICTParams.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZDICTParams.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZDICTParams.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTParams.__create(capacity, SIZEOF);
        return ZDICTParams.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZDICTParams.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZDICTParams.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZDICTParams mallocStack() {
        return ZDICTParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTParams callocStack() {
        return ZDICTParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTParams mallocStack(MemoryStack stack) {
        return ZDICTParams.malloc(stack);
    }

    @Deprecated
    public static ZDICTParams callocStack(MemoryStack stack) {
        return ZDICTParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZDICTParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZDICTParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTParams.calloc(capacity, stack);
    }

    public static ZDICTParams malloc(MemoryStack stack) {
        return ZDICTParams.wrap(ZDICTParams.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZDICTParams calloc(MemoryStack stack) {
        return ZDICTParams.wrap(ZDICTParams.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZDICTParams.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZDICTParams.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncompressionLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPRESSIONLEVEL);
    }

    public static int nnotificationLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)NOTIFICATIONLEVEL);
    }

    public static int ndictID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DICTID);
    }

    public static void ncompressionLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPRESSIONLEVEL, value);
    }

    public static void nnotificationLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NOTIFICATIONLEVEL, value);
    }

    public static void ndictID(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DICTID, value);
    }

    static {
        Struct.Layout layout = ZDICTParams.__struct(ZDICTParams.__member(4), ZDICTParams.__member(4), ZDICTParams.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMPRESSIONLEVEL = layout.offsetof(0);
        NOTIFICATIONLEVEL = layout.offsetof(1);
        DICTID = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZDICTParams, Buffer>
    implements NativeResource {
        private static final ZDICTParams ELEMENT_FACTORY = ZDICTParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZDICTParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int compressionLevel() {
            return ZDICTParams.ncompressionLevel(this.address());
        }

        @NativeType(value="unsigned")
        public int notificationLevel() {
            return ZDICTParams.nnotificationLevel(this.address());
        }

        @NativeType(value="unsigned")
        public int dictID() {
            return ZDICTParams.ndictID(this.address());
        }

        public Buffer compressionLevel(int value) {
            ZDICTParams.ncompressionLevel(this.address(), value);
            return this;
        }

        public Buffer notificationLevel(@NativeType(value="unsigned") int value) {
            ZDICTParams.nnotificationLevel(this.address(), value);
            return this;
        }

        public Buffer dictID(@NativeType(value="unsigned") int value) {
            ZDICTParams.ndictID(this.address(), value);
            return this;
        }
    }
}

