/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZDICTParams;

@NativeType(value="struct ZDICT_fastCover_params_t")
public class ZDICTFastCoverParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int K;
    public static final int D;
    public static final int F;
    public static final int STEPS;
    public static final int NBTHREADS;
    public static final int SPLITPOINT;
    public static final int ACCEL;
    public static final int ZPARAMS;

    public ZDICTFastCoverParams(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZDICTFastCoverParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int k() {
        return ZDICTFastCoverParams.nk(this.address());
    }

    @NativeType(value="unsigned")
    public int d() {
        return ZDICTFastCoverParams.nd(this.address());
    }

    @NativeType(value="unsigned")
    public int f() {
        return ZDICTFastCoverParams.nf(this.address());
    }

    @NativeType(value="unsigned")
    public int steps() {
        return ZDICTFastCoverParams.nsteps(this.address());
    }

    @NativeType(value="unsigned")
    public int nbThreads() {
        return ZDICTFastCoverParams.nnbThreads(this.address());
    }

    public double splitPoint() {
        return ZDICTFastCoverParams.nsplitPoint(this.address());
    }

    @NativeType(value="unsigned")
    public int accel() {
        return ZDICTFastCoverParams.naccel(this.address());
    }

    @NativeType(value="ZDICT_params_t")
    public ZDICTParams zParams() {
        return ZDICTFastCoverParams.nzParams(this.address());
    }

    public ZDICTFastCoverParams k(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nk(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams d(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nd(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams f(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nf(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams steps(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nsteps(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams nbThreads(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.nnbThreads(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams splitPoint(double value) {
        ZDICTFastCoverParams.nsplitPoint(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams accel(@NativeType(value="unsigned") int value) {
        ZDICTFastCoverParams.naccel(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
        ZDICTFastCoverParams.nzParams(this.address(), value);
        return this;
    }

    public ZDICTFastCoverParams zParams(Consumer<ZDICTParams> consumer) {
        consumer.accept(this.zParams());
        return this;
    }

    public ZDICTFastCoverParams set(int k, int d, int f, int steps, int nbThreads, double splitPoint, int accel, ZDICTParams zParams) {
        this.k(k);
        this.d(d);
        this.f(f);
        this.steps(steps);
        this.nbThreads(nbThreads);
        this.splitPoint(splitPoint);
        this.accel(accel);
        this.zParams(zParams);
        return this;
    }

    public ZDICTFastCoverParams set(ZDICTFastCoverParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZDICTFastCoverParams malloc() {
        return ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZDICTFastCoverParams calloc() {
        return ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZDICTFastCoverParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, MemoryUtil.memAddress(container), container);
    }

    public static ZDICTFastCoverParams create(long address) {
        return ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, address);
    }

    @Nullable
    public static ZDICTFastCoverParams createSafe(long address) {
        return address == 0L ? null : ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZDICTFastCoverParams.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZDICTFastCoverParams.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZDICTFastCoverParams.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZDICTFastCoverParams.__create(capacity, SIZEOF);
        return ZDICTFastCoverParams.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZDICTFastCoverParams.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZDICTFastCoverParams.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZDICTFastCoverParams mallocStack() {
        return ZDICTFastCoverParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTFastCoverParams callocStack() {
        return ZDICTFastCoverParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZDICTFastCoverParams mallocStack(MemoryStack stack) {
        return ZDICTFastCoverParams.malloc(stack);
    }

    @Deprecated
    public static ZDICTFastCoverParams callocStack(MemoryStack stack) {
        return ZDICTFastCoverParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZDICTFastCoverParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZDICTFastCoverParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTFastCoverParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTFastCoverParams.calloc(capacity, stack);
    }

    public static ZDICTFastCoverParams malloc(MemoryStack stack) {
        return ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZDICTFastCoverParams calloc(MemoryStack stack) {
        return ZDICTFastCoverParams.wrap(ZDICTFastCoverParams.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZDICTFastCoverParams.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZDICTFastCoverParams.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nk(long struct) {
        return UNSAFE.getInt(null, struct + (long)K);
    }

    public static int nd(long struct) {
        return UNSAFE.getInt(null, struct + (long)D);
    }

    public static int nf(long struct) {
        return UNSAFE.getInt(null, struct + (long)F);
    }

    public static int nsteps(long struct) {
        return UNSAFE.getInt(null, struct + (long)STEPS);
    }

    public static int nnbThreads(long struct) {
        return UNSAFE.getInt(null, struct + (long)NBTHREADS);
    }

    public static double nsplitPoint(long struct) {
        return UNSAFE.getDouble(null, struct + (long)SPLITPOINT);
    }

    public static int naccel(long struct) {
        return UNSAFE.getInt(null, struct + (long)ACCEL);
    }

    public static ZDICTParams nzParams(long struct) {
        return ZDICTParams.create(struct + (long)ZPARAMS);
    }

    public static void nk(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)K, value);
    }

    public static void nd(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)D, value);
    }

    public static void nf(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)F, value);
    }

    public static void nsteps(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STEPS, value);
    }

    public static void nnbThreads(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NBTHREADS, value);
    }

    public static void nsplitPoint(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)SPLITPOINT, value);
    }

    public static void naccel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ACCEL, value);
    }

    public static void nzParams(long struct, ZDICTParams value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ZPARAMS, ZDICTParams.SIZEOF);
    }

    static {
        Struct.Layout layout = ZDICTFastCoverParams.__struct(ZDICTFastCoverParams.__member(4), ZDICTFastCoverParams.__member(4), ZDICTFastCoverParams.__member(4), ZDICTFastCoverParams.__member(4), ZDICTFastCoverParams.__member(4), ZDICTFastCoverParams.__member(8), ZDICTFastCoverParams.__member(4), ZDICTFastCoverParams.__member(ZDICTParams.SIZEOF, ZDICTParams.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        K = layout.offsetof(0);
        D = layout.offsetof(1);
        F = layout.offsetof(2);
        STEPS = layout.offsetof(3);
        NBTHREADS = layout.offsetof(4);
        SPLITPOINT = layout.offsetof(5);
        ACCEL = layout.offsetof(6);
        ZPARAMS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<ZDICTFastCoverParams, Buffer>
    implements NativeResource {
        private static final ZDICTFastCoverParams ELEMENT_FACTORY = ZDICTFastCoverParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZDICTFastCoverParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int k() {
            return ZDICTFastCoverParams.nk(this.address());
        }

        @NativeType(value="unsigned")
        public int d() {
            return ZDICTFastCoverParams.nd(this.address());
        }

        @NativeType(value="unsigned")
        public int f() {
            return ZDICTFastCoverParams.nf(this.address());
        }

        @NativeType(value="unsigned")
        public int steps() {
            return ZDICTFastCoverParams.nsteps(this.address());
        }

        @NativeType(value="unsigned")
        public int nbThreads() {
            return ZDICTFastCoverParams.nnbThreads(this.address());
        }

        public double splitPoint() {
            return ZDICTFastCoverParams.nsplitPoint(this.address());
        }

        @NativeType(value="unsigned")
        public int accel() {
            return ZDICTFastCoverParams.naccel(this.address());
        }

        @NativeType(value="ZDICT_params_t")
        public ZDICTParams zParams() {
            return ZDICTFastCoverParams.nzParams(this.address());
        }

        public Buffer k(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nk(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nd(this.address(), value);
            return this;
        }

        public Buffer f(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nf(this.address(), value);
            return this;
        }

        public Buffer steps(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nsteps(this.address(), value);
            return this;
        }

        public Buffer nbThreads(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.nnbThreads(this.address(), value);
            return this;
        }

        public Buffer splitPoint(double value) {
            ZDICTFastCoverParams.nsplitPoint(this.address(), value);
            return this;
        }

        public Buffer accel(@NativeType(value="unsigned") int value) {
            ZDICTFastCoverParams.naccel(this.address(), value);
            return this;
        }

        public Buffer zParams(@NativeType(value="ZDICT_params_t") ZDICTParams value) {
            ZDICTFastCoverParams.nzParams(this.address(), value);
            return this;
        }

        public Buffer zParams(Consumer<ZDICTParams> consumer) {
            consumer.accept(this.zParams());
            return this;
        }
    }
}

