/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE;
    public static final int UNIT;

    public YGValue(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), YGValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float value() {
        return YGValue.nvalue(this.address());
    }

    @NativeType(value="YGUnit")
    public int unit() {
        return YGValue.nunit(this.address());
    }

    public YGValue value(float value) {
        YGValue.nvalue(this.address(), value);
        return this;
    }

    public YGValue unit(@NativeType(value="YGUnit") int value) {
        YGValue.nunit(this.address(), value);
        return this;
    }

    public YGValue set(float value, int unit) {
        this.value(value);
        this.unit(unit);
        return this;
    }

    public YGValue set(YGValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static YGValue malloc() {
        return YGValue.wrap(YGValue.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static YGValue calloc() {
        return YGValue.wrap(YGValue.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static YGValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return YGValue.wrap(YGValue.class, MemoryUtil.memAddress(container), container);
    }

    public static YGValue create(long address) {
        return YGValue.wrap(YGValue.class, address);
    }

    @Nullable
    public static YGValue createSafe(long address) {
        return address == 0L ? null : YGValue.wrap(YGValue.class, address);
    }

    public static Buffer malloc(int capacity) {
        return YGValue.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(YGValue.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return YGValue.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGValue.__create(capacity, SIZEOF);
        return YGValue.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return YGValue.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGValue.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static YGValue mallocStack() {
        return YGValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGValue callocStack() {
        return YGValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGValue mallocStack(MemoryStack stack) {
        return YGValue.malloc(stack);
    }

    @Deprecated
    public static YGValue callocStack(MemoryStack stack) {
        return YGValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return YGValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return YGValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGValue.calloc(capacity, stack);
    }

    public static YGValue malloc(MemoryStack stack) {
        return YGValue.wrap(YGValue.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGValue calloc(MemoryStack stack) {
        return YGValue.wrap(YGValue.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return YGValue.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return YGValue.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nvalue(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VALUE);
    }

    public static int nunit(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNIT);
    }

    public static void nvalue(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VALUE, value);
    }

    public static void nunit(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNIT, value);
    }

    static {
        Struct.Layout layout = YGValue.__struct(YGValue.__member(4), YGValue.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE = layout.offsetof(0);
        UNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGValue, Buffer>
    implements NativeResource {
        private static final YGValue ELEMENT_FACTORY = YGValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected YGValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float value() {
            return YGValue.nvalue(this.address());
        }

        @NativeType(value="YGUnit")
        public int unit() {
            return YGValue.nunit(this.address());
        }

        public Buffer value(float value) {
            YGValue.nvalue(this.address(), value);
            return this;
        }

        public Buffer unit(@NativeType(value="YGUnit") int value) {
            YGValue.nunit(this.address(), value);
            return this;
        }
    }
}

