/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_state_t")
public class XXH64State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN;
    public static final int V;
    public static final int MEM64;
    public static final int MEMSIZE;
    public static final int RESERVED32;
    public static final int RESERVED64;

    public XXH64State(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH64State.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH64_hash_t")
    public long total_len() {
        return XXH64State.ntotal_len(this.address());
    }

    @NativeType(value="XXH64_hash_t[4]")
    public LongBuffer v() {
        return XXH64State.nv(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long v(int index) {
        return XXH64State.nv(this.address(), index);
    }

    @NativeType(value="XXH64_hash_t[4]")
    public LongBuffer mem64() {
        return XXH64State.nmem64(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long mem64(int index) {
        return XXH64State.nmem64(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int memsize() {
        return XXH64State.nmemsize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved32() {
        return XXH64State.nreserved32(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long reserved64() {
        return XXH64State.nreserved64(this.address());
    }

    public static XXH64State malloc() {
        return XXH64State.wrap(XXH64State.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XXH64State calloc() {
        return XXH64State.wrap(XXH64State.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XXH64State create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XXH64State.wrap(XXH64State.class, MemoryUtil.memAddress(container), container);
    }

    public static XXH64State create(long address) {
        return XXH64State.wrap(XXH64State.class, address);
    }

    @Nullable
    public static XXH64State createSafe(long address) {
        return address == 0L ? null : XXH64State.wrap(XXH64State.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XXH64State.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XXH64State.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH64State.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64State.__create(capacity, SIZEOF);
        return XXH64State.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XXH64State.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XXH64State.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static XXH64State mallocStack() {
        return XXH64State.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64State callocStack() {
        return XXH64State.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64State mallocStack(MemoryStack stack) {
        return XXH64State.malloc(stack);
    }

    @Deprecated
    public static XXH64State callocStack(MemoryStack stack) {
        return XXH64State.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH64State.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH64State.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64State.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64State.calloc(capacity, stack);
    }

    public static XXH64State malloc(MemoryStack stack) {
        return XXH64State.wrap(XXH64State.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64State calloc(MemoryStack stack) {
        return XXH64State.wrap(XXH64State.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XXH64State.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XXH64State.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntotal_len(long struct) {
        return UNSAFE.getLong(null, struct + (long)TOTAL_LEN);
    }

    public static LongBuffer nv(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)V, 4);
    }

    public static long nv(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)V + Checks.check(index, 4) * 8L);
    }

    public static LongBuffer nmem64(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)MEM64, 4);
    }

    public static long nmem64(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)MEM64 + Checks.check(index, 4) * 8L);
    }

    public static int nmemsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMSIZE);
    }

    public static int nreserved32(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESERVED32);
    }

    public static long nreserved64(long struct) {
        return UNSAFE.getLong(null, struct + (long)RESERVED64);
    }

    static {
        Struct.Layout layout = XXH64State.__struct(XXH64State.__member(8), XXH64State.__array(8, 4), XXH64State.__array(8, 4), XXH64State.__member(4), XXH64State.__member(4), XXH64State.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN = layout.offsetof(0);
        V = layout.offsetof(1);
        MEM64 = layout.offsetof(2);
        MEMSIZE = layout.offsetof(3);
        RESERVED32 = layout.offsetof(4);
        RESERVED64 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XXH64State, Buffer>
    implements NativeResource {
        private static final XXH64State ELEMENT_FACTORY = XXH64State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XXH64State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH64_hash_t")
        public long total_len() {
            return XXH64State.ntotal_len(this.address());
        }

        @NativeType(value="XXH64_hash_t[4]")
        public LongBuffer v() {
            return XXH64State.nv(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long v(int index) {
            return XXH64State.nv(this.address(), index);
        }

        @NativeType(value="XXH64_hash_t[4]")
        public LongBuffer mem64() {
            return XXH64State.nmem64(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long mem64(int index) {
            return XXH64State.nmem64(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int memsize() {
            return XXH64State.nmemsize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved32() {
            return XXH64State.nreserved32(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long reserved64() {
            return XXH64State.nreserved64(this.address());
        }
    }
}

