/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_canonical_t")
public class XXH64Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    public XXH64Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH64Canonical.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[8]")
    public ByteBuffer digest() {
        return XXH64Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH64Canonical.ndigest(this.address(), index);
    }

    public static XXH64Canonical malloc() {
        return XXH64Canonical.wrap(XXH64Canonical.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XXH64Canonical calloc() {
        return XXH64Canonical.wrap(XXH64Canonical.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XXH64Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XXH64Canonical.wrap(XXH64Canonical.class, MemoryUtil.memAddress(container), container);
    }

    public static XXH64Canonical create(long address) {
        return XXH64Canonical.wrap(XXH64Canonical.class, address);
    }

    @Nullable
    public static XXH64Canonical createSafe(long address) {
        return address == 0L ? null : XXH64Canonical.wrap(XXH64Canonical.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XXH64Canonical.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XXH64Canonical.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH64Canonical.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64Canonical.__create(capacity, SIZEOF);
        return XXH64Canonical.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XXH64Canonical.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XXH64Canonical.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static XXH64Canonical mallocStack() {
        return XXH64Canonical.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64Canonical callocStack() {
        return XXH64Canonical.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64Canonical mallocStack(MemoryStack stack) {
        return XXH64Canonical.malloc(stack);
    }

    @Deprecated
    public static XXH64Canonical callocStack(MemoryStack stack) {
        return XXH64Canonical.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH64Canonical.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH64Canonical.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.calloc(capacity, stack);
    }

    public static XXH64Canonical malloc(MemoryStack stack) {
        return XXH64Canonical.wrap(XXH64Canonical.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64Canonical calloc(MemoryStack stack) {
        return XXH64Canonical.wrap(XXH64Canonical.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XXH64Canonical.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XXH64Canonical.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DIGEST, 8);
    }

    public static byte ndigest(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DIGEST + Checks.check(index, 8) * 1L);
    }

    static {
        Struct.Layout layout = XXH64Canonical.__struct(XXH64Canonical.__array(1, 8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH64Canonical, Buffer>
    implements NativeResource {
        private static final XXH64Canonical ELEMENT_FACTORY = XXH64Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XXH64Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[8]")
        public ByteBuffer digest() {
            return XXH64Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH64Canonical.ndigest(this.address(), index);
        }
    }
}

